package net.danygames2014.debugutilities.item;

import net.minecraft.class_127;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_428;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.client.item.CustomTooltipProvider;
import net.modificationstation.stationapi.api.template.item.TemplatePickaxeItem;
import net.modificationstation.stationapi.api.util.Formatting;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class DebugPickaxeItem extends TemplatePickaxeItem implements CustomTooltipProvider {
    public DebugPickaxeItem(Identifier identifier, class_428 material) {
        super(identifier, material);
    }

    @Override
    public boolean method_446(class_31 stack, class_127 target, class_127 attacker) {
        return true;
    }

    @Override
    public boolean method_437(class_31 stack, int blockId, int x, int y, int z, class_127 miner) {
        return true;
    }

    @Override
    public boolean method_444(class_31 stack, class_54 user, class_18 world, int x, int y, int z, int side) {
        if (world.field_180) {
            return super.method_444(stack, user, world, x, y, z, side);
        }

        BlockState state = world.getBlockState(x, y, z);
        int meta = world.method_1778(x, y, z);

        if (!state.isAir()) {
            state.getBlock().method_1592(world, x, y, z, meta);
            world.setBlockStateWithNotify(x, y, z, States.AIR.get());
        }

        return true;
    }

    @Override
    public @NotNull String[] getTooltip(class_31 itemStack, String originalTooltip) {
        return new String[]{
                originalTooltip,
                Formatting.GREEN + "Right-click on a block to insta-mine it",
        };
    }
}
