/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.debugutilities.item;

import java.util.Collection;
import java.util.Iterator;
import net.danygames2014.uniwrench.api.WrenchMode;
import net.danygames2014.uniwrench.util.HotbarTooltipHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_54;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.registry.BlockRegistry;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.util.Identifier;

public class StateCycleMode
extends WrenchMode {
    public StateCycleMode(Identifier identifier) {
        super(identifier);
    }

    public boolean wrenchLeftClick(class_31 stack, class_54 player, boolean isSneaking, class_18 world, int x, int y, int z, int side, WrenchMode wrenchMode) {
        if (world.field_180) {
            return super.wrenchLeftClick(stack, player, isSneaking, world, x, y, z, side, wrenchMode);
        }
        this.cycleSelectedProperty(stack, world.getBlockState(x, y, z));
        String selectedProperty = this.getSelectedProperty(stack, world.getBlockState(x, y, z));
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            HotbarTooltipHelper.setTooltip((String)("Selected Property: " + selectedProperty), (int)40);
        } else {
            player.method_490("Selected Property: " + selectedProperty);
        }
        return true;
    }

    public boolean wrenchRightClick(class_31 stack, class_54 player, boolean isSneaking, class_18 world, int x, int y, int z, int side, WrenchMode wrenchMode) {
        if (world.field_180) {
            return super.wrenchLeftClick(stack, player, isSneaking, world, x, y, z, side, wrenchMode);
        }
        String selectedPropertyName = this.getSelectedProperty(stack, world.getBlockState(x, y, z));
        if (selectedPropertyName.isBlank()) {
            return false;
        }
        if (selectedPropertyName.equals("meta")) {
            int meta = world.method_1778(x, y, z);
            meta = isSneaking ? (meta <= 0 ? 15 : meta - 1) : (meta >= 15 ? 0 : meta + 1);
            world.method_215(x, y, z, meta);
            world.method_243(x, y, z);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                HotbarTooltipHelper.setTooltip((String)("Set property meta to " + meta), (int)40);
            } else {
                player.method_490("Set property meta to " + meta);
            }
        } else {
            BlockState state = world.getBlockState(x, y, z);
            Property<?> property = this.findProperty(state, selectedPropertyName);
            state = (BlockState)state.cycle(property);
            if (isSneaking) {
                world.setBlockState(x, y, z, state);
            } else {
                world.setBlockStateWithNotify(x, y, z, state);
            }
            if (property != null) {
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    HotbarTooltipHelper.setTooltip((String)("Set property " + property.getName() + " to " + state.get(property).toString()), (int)40);
                } else {
                    player.method_490("Set property " + property.getName() + " to " + state.get(property).toString());
                }
            }
        }
        return true;
    }

    private Property<?> findProperty(BlockState state, String propertyName) {
        Collection properties = state.getProperties();
        for (Property property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    private String getSelectedProperty(class_31 stack, BlockState state) {
        class_8 selectedProperties = stack.getStationNbt().method_1033("selectedProperties");
        Identifier blockId = BlockRegistry.INSTANCE.getId((Object)state.getBlock());
        if (blockId == null) {
            return "";
        }
        String selectedPropertyName = selectedProperties.method_1031(blockId.toString());
        if (selectedPropertyName.isBlank()) {
            selectedPropertyName = this.selectFirstProperty(state);
            this.setSelectedProperty(stack, state, selectedPropertyName);
        }
        return selectedPropertyName;
    }

    private void setSelectedProperty(class_31 stack, BlockState state, String propertyName) {
        class_8 selectedProperties = stack.getStationNbt().method_1033("selectedProperties");
        Identifier blockId = BlockRegistry.INSTANCE.getId((Object)state.getBlock());
        if (blockId == null) {
            return;
        }
        selectedProperties.method_1019(blockId.toString(), propertyName);
        stack.getStationNbt().method_1018("selectedProperties", selectedProperties);
    }

    private void cycleSelectedProperty(class_31 stack, BlockState state) {
        String currentName = this.getSelectedProperty(stack, state);
        String nextName = this.selectNextProperty(state, currentName);
        this.setSelectedProperty(stack, state, nextName);
    }

    private String selectFirstProperty(BlockState state) {
        Collection props = state.getProperties();
        if (props.isEmpty()) {
            return "meta";
        }
        return ((Property)props.iterator().next()).getName();
    }

    private String selectNextProperty(BlockState state, String currentName) {
        Collection props = state.getProperties();
        if (props.isEmpty()) {
            return "meta";
        }
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            if (!property.getName().equals(currentName)) continue;
            if (iter.hasNext()) {
                return ((Property)iter.next()).getName();
            }
            return "meta";
        }
        return ((Property)props.iterator().next()).getName();
    }
}

