/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkComponent;
import net.danygames2014.nyalib.network.NetworkComponentEntry;
import net.danygames2014.nyalib.network.NetworkEdgeComponent;
import net.danygames2014.nyalib.network.NetworkNodeComponent;
import net.danygames2014.nyalib.network.NetworkType;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_50;
import net.minecraft.class_63;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.registry.DimensionRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class NetworkManager {
    public static HashMap<class_50, HashMap<Identifier, ArrayList<Network>>> NETWORKS = new HashMap();
    public static AtomicInteger NEXT_ID = new AtomicInteger(0);
    public static ArrayList<Network> removeQueue = new ArrayList();

    public static ArrayList<Network> getNetworks(class_50 dimension, Identifier networkTypeIdentifier) {
        HashMap<Identifier, ArrayList<Network>> netDims = NETWORKS.get(dimension);
        if (netDims == null) {
            return new ArrayList<Network>();
        }
        ArrayList nets = netDims.get(networkTypeIdentifier);
        return nets != null ? nets : new ArrayList();
    }

    public static HashMap<Identifier, ArrayList<Network>> getNetworks(class_50 dimension) {
        return NETWORKS.get(dimension);
    }

    public static void addNetwork(class_50 dimension, Network network) {
        ArrayList<Network> typeNetworks;
        HashMap<Object, ArrayList<Network>> dimNetworks = NETWORKS.get(dimension);
        if (network == null) {
            return;
        }
        if (dimNetworks == null) {
            dimNetworks = new HashMap();
            NETWORKS.put(dimension, dimNetworks);
        }
        if ((typeNetworks = dimNetworks.get(network.type.getIdentifier())) == null) {
            typeNetworks = new ArrayList();
            dimNetworks.put(network.type.getIdentifier(), typeNetworks);
        }
        typeNetworks.add(network);
    }

    public static Network createNetwork(class_50 dimension, NetworkType networkType) {
        Network network;
        try {
            network = networkType.getNetworkClass().getDeclaredConstructor(class_18.class, NetworkType.class).newInstance(dimension.field_2173, networkType);
        }
        catch (Exception e) {
            NyaLib.LOGGER.error("Error when creating a network of type {}", (Object)networkType.getIdentifier(), (Object)e);
            return null;
        }
        network.id = NEXT_ID.getAndIncrement();
        NetworkManager.addNetwork(dimension, network);
        return network;
    }

    public static void removeNetwork(Network network) {
        if (!removeQueue.contains(network)) {
            removeQueue.add(network);
        }
    }

    public static void removeQueuedNetworks() {
        for (Network toremove : removeQueue) {
            NetworkManager.removeNetworkInternal(toremove);
        }
    }

    private static boolean removeNetworkInternal(Network toRemove) {
        for (Map.Entry<class_50, HashMap<Identifier, ArrayList<Network>>> dimensions : NETWORKS.entrySet()) {
            for (Map.Entry<Identifier, ArrayList<Network>> networks : dimensions.getValue().entrySet()) {
                for (Network network : networks.getValue()) {
                    if (network != toRemove) continue;
                    networks.getValue().remove(network);
                    return true;
                }
            }
        }
        return false;
    }

    public static Network getAt(class_50 dimension, int x, int y, int z, Identifier networkTypeIdentifier) {
        for (Network net : NetworkManager.getNetworks(dimension, networkTypeIdentifier)) {
            if (!net.isAt(x, y, z)) continue;
            return net;
        }
        return null;
    }

    public static ArrayList<Network> getAt(class_50 dimension, int x, int y, int z, ArrayList<NetworkType> networkTypes) {
        ArrayList<Network> networks = new ArrayList<Network>();
        for (NetworkType networkType : networkTypes) {
            for (Network net : NetworkManager.getNetworks(dimension, networkType.getIdentifier())) {
                if (!net.isAt(x, y, z)) continue;
                networks.add(net);
            }
        }
        return networks;
    }

    public static ArrayList<Network> getAt(class_50 dimension, int x, int y, int z) {
        ArrayList<Network> networks = new ArrayList<Network>();
        for (ArrayList<Network> netsOfType : NetworkManager.getNetworks(dimension).values()) {
            for (Network net : netsOfType) {
                if (!net.isAt(x, y, z)) continue;
                networks.add(net);
            }
        }
        return networks;
    }

    public static ArrayList<Network> getNeighbors(class_18 world, int x, int y, int z) {
        ArrayList<Network> neighborNets = new ArrayList<Network>();
        for (ArrayList<Network> networksOfType : NetworkManager.getNetworks(world.field_216).values()) {
            for (Network network : networksOfType) {
                for (Direction direction : Direction.values()) {
                    if (!network.isAt(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ())) continue;
                    neighborNets.add(network);
                }
            }
        }
        return neighborNets;
    }

    public static ArrayList<Network> getNeighbors(class_18 world, int x, int y, int z, Identifier networkTypeIdentifier) {
        ArrayList<Network> neighborNets = new ArrayList<Network>();
        for (Network network : NetworkManager.getNetworks(world.field_216, networkTypeIdentifier)) {
            for (Direction direction : Direction.values()) {
                if (!network.isAt(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ())) continue;
                neighborNets.add(network);
            }
        }
        return neighborNets;
    }

    public static <T extends class_17> void addBlock(class_18 world, int x, int y, int z, T component) {
        if (component == null) {
            return;
        }
        block7: for (NetworkType networkType : ((NetworkComponent)component).getNetworkTypes()) {
            Network networkToJoin;
            ArrayList<PotentialNeighbor> nodeNeighbors = new ArrayList<PotentialNeighbor>(2);
            ArrayList<PotentialNeighbor> edgeNeighbors = new ArrayList<PotentialNeighbor>(2);
            ArrayList<Network> potentialNets = new ArrayList<Network>();
            potentialNets.addAll(NetworkManager.getNetworks(world.field_216, networkType.getIdentifier()));
            for (Network potentialNet : potentialNets) {
                for (Direction direction : Direction.values()) {
                    NetworkComponentEntry componentEntry;
                    class_63 side = new class_63(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ());
                    if (!potentialNet.isAt(side) || !((NetworkComponent)component).canConnectTo(world, x, y, z, potentialNet, direction) || !(componentEntry = potentialNet.getEntry(side)).component().canConnectTo(world, side.field_1482, side.field_1483, side.field_1484, null, direction.getOpposite())) continue;
                    if (componentEntry.component() instanceof NetworkNodeComponent) {
                        nodeNeighbors.add(new PotentialNeighbor(componentEntry, potentialNet, side));
                        continue;
                    }
                    if (!(componentEntry.component() instanceof NetworkEdgeComponent)) continue;
                    edgeNeighbors.add(new PotentialNeighbor(componentEntry, potentialNet, side));
                }
            }
            if (component instanceof NetworkEdgeComponent) {
                switch (nodeNeighbors.size()) {
                    case 0: {
                        Network network = NetworkManager.createNetwork(world.field_216, networkType);
                        if (network == null) continue block7;
                        network.addBlock(x, y, z, component, true);
                        network.update();
                        break;
                    }
                    default: {
                        for (PotentialNeighbor neighbor : nodeNeighbors) {
                            if (!(neighbor.entry.component() instanceof NetworkNodeComponent)) continue;
                            neighbor.network.addBlock(x, y, z, component, true);
                            neighbor.network.update();
                        }
                        continue block7;
                    }
                }
                continue;
            }
            if (!(component instanceof NetworkNodeComponent)) continue;
            switch (nodeNeighbors.size()) {
                case 0: {
                    networkToJoin = NetworkManager.createNetwork(world.field_216, networkType);
                    break;
                }
                case 1: {
                    networkToJoin = ((PotentialNeighbor)nodeNeighbors.get((int)0)).network;
                    break;
                }
                default: {
                    networkToJoin = ((PotentialNeighbor)nodeNeighbors.get((int)0)).network;
                    for (int i = 1; i < nodeNeighbors.size(); ++i) {
                        if (((PotentialNeighbor)nodeNeighbors.get((int)i)).network.getId() == networkToJoin.getId()) continue;
                        networkToJoin.components.putAll(((PotentialNeighbor)nodeNeighbors.get((int)i)).network.components);
                        ((PotentialNeighbor)nodeNeighbors.get((int)i)).network.components.clear();
                        NetworkManager.removeNetwork(((PotentialNeighbor)nodeNeighbors.get((int)i)).network);
                    }
                }
            }
            for (PotentialNeighbor neighbor : edgeNeighbors) {
                if (neighbor.network.components.size() <= 1 && networkToJoin != null) {
                    networkToJoin.components.putAll(neighbor.network.components);
                    neighbor.network.components.clear();
                    NetworkManager.removeNetwork(neighbor.network);
                    continue;
                }
                if (neighbor.network.components.size() <= 1 || networkToJoin == null) continue;
                networkToJoin.addBlock(neighbor.position.field_1482, neighbor.position.field_1483, neighbor.position.field_1484, neighbor.entry.block(), true);
                networkToJoin.update();
            }
            if (networkToJoin == null) continue;
            networkToJoin.addBlock(x, y, z, component, true);
            networkToJoin.update();
        }
    }

    public static <T extends class_17> void removeBlock(class_18 world, int x, int y, int z, T component) {
        block8: for (Network net : NetworkManager.getAt(world.field_216, x, y, z, ((NetworkComponent)component).getNetworkTypes())) {
            int i;
            ArrayList<class_63> neighborBlocks = new ArrayList<class_63>();
            for (Direction direction : Direction.values()) {
                class_63 neighborPos = new class_63(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ());
                if (!net.isAt(neighborPos.field_1482, neighborPos.field_1483, neighborPos.field_1484)) continue;
                neighborBlocks.add(neighborPos);
            }
            NyaLib.LOGGER.debug("NET SIZE: {} | NEIGHBORS FOUND : {}", (Object)net.components.size(), (Object)neighborBlocks.size());
            switch (neighborBlocks.size()) {
                case 0: {
                    NyaLib.LOGGER.debug("Last block in network, removing network with ID {}", (Object)net.getId());
                    net.removeBlock(x, y, z, true);
                    if (net.components.isEmpty()) {
                        NetworkManager.removeNetwork(net);
                        continue block8;
                    }
                    NyaLib.LOGGER.warn("Removed a block from network {} with no neighbors but the network still has {} blocks. Network will not be deleted", (Object)net.getId(), (Object)net.components.size());
                    continue block8;
                }
                case 1: {
                    NyaLib.LOGGER.debug("Only one neighbor, its a stump and can be removed normally");
                    net.removeBlock(x, y, z, true);
                    continue block8;
                }
            }
            net.removeBlock(x, y, z, true);
            ArrayList<ArrayList<class_63>> potentialNetworks = new ArrayList<ArrayList<class_63>>(4);
            for (Direction dir : Direction.values()) {
                class_63 side = new class_63(x + dir.getOffsetX(), y + dir.getOffsetY(), z + dir.getOffsetZ());
                if (!net.isAt(side.field_1482, side.field_1483, side.field_1484)) continue;
                ArrayList<class_63> discoveredBlocks = net.walk(side);
                NyaLib.LOGGER.debug("Discovered a potential network of {} blocks", (Object)discoveredBlocks.size());
                boolean exists = false;
                block11: for (ArrayList arrayList : potentialNetworks) {
                    for (class_63 neighbor : discoveredBlocks) {
                        if (!(world.getBlockState(neighbor.field_1482, neighbor.field_1483, neighbor.field_1484).getBlock() instanceof NetworkNodeComponent) || !arrayList.contains(neighbor)) continue;
                        exists = true;
                        continue block11;
                    }
                }
                if (exists) continue;
                potentialNetworks.add(discoveredBlocks);
            }
            NyaLib.LOGGER.debug("There will be {} new networks", (Object)potentialNetworks.size());
            switch (potentialNetworks.size()) {
                case 0: {
                    NyaLib.LOGGER.warn("There were 0 potential networks when splitting, this shouldn't happen");
                    continue block8;
                }
                case 1: {
                    continue block8;
                }
            }
            int largestNetworkIndex = 0;
            int largestNetworkSize = 0;
            for (i = 0; i < potentialNetworks.size(); ++i) {
                if (((ArrayList)potentialNetworks.get(i)).size() <= largestNetworkSize) continue;
                largestNetworkIndex = i;
                largestNetworkSize = ((ArrayList)potentialNetworks.get(i)).size();
            }
            for (i = 0; i < potentialNetworks.size(); ++i) {
                if (i == largestNetworkIndex) continue;
                Network newNetwork = NetworkManager.createNetwork(world.field_216, net.type);
                if (newNetwork == null) {
                    NyaLib.LOGGER.error("Unable to initialize a new network when block was removed");
                    return;
                }
                for (class_63 pos : (ArrayList)potentialNetworks.get(i)) {
                    if (NetworkManager.isNode(world, pos.field_1482, pos.field_1483, pos.field_1484)) {
                        net.removeBlock(pos.field_1482, pos.field_1483, pos.field_1484, false);
                        newNetwork.addBlock(pos.field_1482, pos.field_1483, pos.field_1484, world.getBlockState(pos.field_1482, pos.field_1483, pos.field_1484).getBlock(), false);
                        continue;
                    }
                    if (!NetworkManager.isEdge(world, pos.field_1482, pos.field_1483, pos.field_1484)) continue;
                    newNetwork.addBlock(pos.field_1482, pos.field_1483, pos.field_1484, world.getBlockState(pos.field_1482, pos.field_1483, pos.field_1484).getBlock(), false);
                    if (((ArrayList)potentialNetworks.get(largestNetworkIndex)).contains(pos)) continue;
                    net.removeBlock(pos.field_1482, pos.field_1483, pos.field_1484, false);
                }
                newNetwork.update();
            }
            net.update();
        }
    }

    public static boolean isEdge(class_18 world, int x, int y, int z) {
        return world.getBlockState(x, y, z).getBlock() instanceof NetworkEdgeComponent;
    }

    public static boolean isNode(class_18 world, int x, int y, int z) {
        return world.getBlockState(x, y, z).getBlock() instanceof NetworkNodeComponent;
    }

    public static void writeNbt(class_18 world, class_8 nbt) {
        class_8 dimensionsNbt;
        class_50 dim = world.field_216;
        Optional dimIdentifierO = DimensionRegistry.INSTANCE.getIdByLegacyId(dim.field_2179);
        if (dimIdentifierO.isEmpty()) {
            NyaLib.LOGGER.error("Dimension {} not found", (Object)dim.field_2179);
            return;
        }
        Identifier dimIdentifier = (Identifier)dimIdentifierO.get();
        if (!nbt.method_1023("dimensions")) {
            nbt.method_1018("dimensions", new class_8());
        }
        if (!(dimensionsNbt = nbt.method_1033("dimensions")).method_1023(dimIdentifier.toString())) {
            dimensionsNbt.method_1018(dimIdentifier.toString(), new class_8());
        }
        class_8 dimensionNbt = dimensionsNbt.method_1033(dimIdentifier.toString());
        NETWORKS.computeIfAbsent(dim, k -> new HashMap());
        for (Map.Entry<Identifier, ArrayList<Network>> networksOfType : NetworkManager.getNetworks(dim).entrySet()) {
            Identifier type = networksOfType.getKey();
            ArrayList<Network> networks = networksOfType.getValue();
            dimensionNbt.method_1018(type.toString(), new class_8());
            class_8 networksOfTypeNbt = dimensionNbt.method_1033(type.toString());
            for (Network network : networks) {
                networksOfTypeNbt.method_1018("" + network.id, network.toNbt());
            }
        }
        NetworkManager.removeQueuedNetworks();
    }

    public static void readNbt(class_18 world, class_8 nbt) {
        class_50 dim = world.field_216;
        Optional dimIdentifierO = DimensionRegistry.INSTANCE.getIdByLegacyId(dim.field_2179);
        if (dimIdentifierO.isEmpty()) {
            NyaLib.LOGGER.error("Dimension {} not found", (Object)dim.field_2179);
            return;
        }
        Identifier dimIdentifier = (Identifier)dimIdentifierO.get();
        class_8 dimensionsNbt = nbt.method_1033("dimensions");
        class_8 dimensionNbt = dimensionsNbt.method_1033(dimIdentifier.toString());
        for (Object networksOfTypeO : dimensionNbt.method_1024()) {
            if (!(networksOfTypeO instanceof class_8)) continue;
            class_8 networksOfType = (class_8)networksOfTypeO;
            for (Object networksO : networksOfType.method_1024()) {
                if (!(networksO instanceof class_8)) continue;
                class_8 networks = (class_8)networksO;
                Network loadedNet = Network.fromNbt(networks, world, Identifier.of((String)networksOfType.method_626()));
                NetworkManager.addNetwork(dim, loadedNet);
                if (loadedNet == null) continue;
                loadedNet.update();
            }
        }
    }

    record PotentialNeighbor(NetworkComponentEntry entry, Network network, class_63 position) {
    }
}

