/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.fluid;

import java.util.HashMap;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.fluid.Fluid;
import net.modificationstation.stationapi.api.util.Identifier;

public class FluidRegistry {
    public final HashMap<Identifier, Fluid> registry = new HashMap();
    private static FluidRegistry INSTANCE;

    private static FluidRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FluidRegistry();
        }
        return INSTANCE;
    }

    public static void register(Fluid fluid) {
        FluidRegistry.register(fluid.getIdentifier(), fluid);
    }

    public static void register(Identifier identifier, Fluid fluid) {
        if (FluidRegistry.getInstance().registry.containsKey(identifier)) {
            return;
        }
        NyaLib.LOGGER.info("Registering fluid {}", (Object)identifier);
        FluidRegistry.getInstance().registry.put(identifier, fluid);
    }

    public static Fluid get(Identifier identifier) {
        return FluidRegistry.getInstance().registry.getOrDefault(identifier, null);
    }

    public static HashMap<Identifier, Fluid> getRegistry() {
        return FluidRegistry.getInstance().registry;
    }
}

