package net.danygames2014.nyalib.sound;

import net.minecraft.class_18;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;

public class SoundHelper {
    /**
     * Play a sound for all players at their position
     */
    public static void playSound(class_18 world, String sound, float volume, float pitch) {
        for (Object playerO : world.field_200) {
            if (playerO instanceof class_54 player) {
                playSound(player, player.field_1600, player.field_1601, player.field_1602, sound, volume, pitch);
            }
        }
    }

    /**
     * Play a sound on the given position for all players in range
     */
    public static void playSound(class_18 world, double x, double y, double z, String sound, float volume, float pitch, int range) {
        for (Object playerO : world.field_200) {
            if (playerO instanceof class_54 player) {
                if (player.method_1350(x, y, z) <= range) {
                    playSound(player, x, y, z, sound, volume, pitch);
                }
            }
        }
    }

    /**
     * Play a sound on the given position for all players in range of 64 blocks
     */
    public static void playSound(class_18 world, double x, double y, double z, String sound, float volume, float pitch) {
        playSound(world, x, y, z, sound, volume, pitch, 64);
    }

    /**
     * Play a sound to a given player at a given position
     */
    public static void playSound(class_54 player, double x, double y, double z, String sound, float volume, float pitch) {
        PacketHelper.sendTo(player, new SoundPacket(x, y, z, volume, pitch, sound));
    }

    /**
     * Play a sound to a given player at their position
     */
    public static void playSound(class_54 player, String sound, float volume, float pitch) {
        PacketHelper.sendTo(player, new SoundPacket(player.field_1600, player.field_1601, player.field_1602, volume, pitch, sound));
    }

    // Music

    /**
     * Play a sound for all players at their position
     */
    public static void playMusic(class_18 world, String name) {
        for (Object playerO : world.field_200) {
            if (playerO instanceof class_54 player) {
                playMusic(player, player.field_1600, player.field_1601, player.field_1602, name);
            }
        }
    }

    /**
     * Play a sound on the given position for all players in range
     */
    public static void playMusic(class_18 world, double x, double y, double z, String name, int range) {
        for (Object playerO : world.field_200) {
            if (playerO instanceof class_54 player) {
                if (player.method_1350(x, y, z) <= range) {
                    playMusic(player, x, y, z, name);
                }
            }
        }
    }

    /**
     * Play a sound on the given position for all players in range of 64 blocks
     */
    public static void playMusic(class_18 world, double x, double y, double z, String name) {
        playMusic(world, x, y, z, name, 64);
    }

    /**
     * Play a sound to a given player at a given position
     */
    public static void playMusic(class_54 player, double x, double y, double z, String name) {
        if (name == null) {
            name = "";
        }
        
        PacketHelper.sendTo(player, new MusicPacket((int) x, (int) y, (int) z, name));
    }

    /**
     * Play a sound to a given player at their position
     */
    public static void playMusic(class_54 player, String name) {
        if (name == null) {
            name = "";
        }

        PacketHelper.sendTo(player, new MusicPacket((int) player.field_1600, (int) player.field_1601, (int) player.field_1602, name));
    }
}
