package net.danygames2014.nyalib.util;

import net.minecraft.class_63;
import net.modificationstation.stationapi.api.util.math.Direction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AStar {
    class_63 start;
    class_63 end;
    HashMap<class_63, AStarNode> open;
    HashMap<class_63, AStarNode> closed;
    HashMap<class_63, AStarNode> validNodes;

    public AStar(class_63 start, class_63 end, class_63[] avalibleNodes) {
        this.open = new HashMap<>();
        this.closed = new HashMap<>();
        this.validNodes = new HashMap<>();
        this.start = start;
        this.end = end;

        for (class_63 node : avalibleNodes) {
            validNodes.put(node, new AStarNode(node, null));
        }

        open.put(start, new AStarNode(start, null));
    }

    public class_63[] calculate() {
        AStarNode endNode = null;
        
        while (endNode == null) {
            AStarNode current = getLowestFCost();
            open.remove(current.position);
            closed.put(current.position, current);

            if (current.position.equals(end)) {
                endNode = current;
            }

            for (Direction direction : Direction.values()) {
                class_63 neighbor = new class_63(current.position.field_1482 + direction.getOffsetX(), current.position.field_1483 + direction.getOffsetY(), current.position.field_1484 + direction.getOffsetZ());
                if (!validNodes.containsKey(neighbor) || closed.containsKey(neighbor)) {
                    continue;
                }

                AStarNode neighborNode = validNodes.get(neighbor);
                double neighborCost = neighborNode.fCost;
                double newCost = neighborNode.calculateCost(start, end);
                
                if(newCost < neighborCost || !open.containsKey(neighbor)) {
                    neighborNode.fCost = newCost;
                    neighborNode.parent = current;
                    if(!open.containsKey(neighbor)) {
                        open.put(neighbor, neighborNode);
                    }
                }

            }
        }

        AStarNode traversedNode = endNode;
        ArrayList<class_63> path = new ArrayList<>();
        
        while(traversedNode != null) {
            path.add(traversedNode.position);
            traversedNode = traversedNode.parent;
        }

        Collections.reverse(path);

        return path.toArray(new class_63[0]);
    }

    AStarNode getLowestFCost() {
        double lowestCost = Double.MAX_VALUE;
        AStarNode bestNode = null;

        for (Map.Entry<class_63, AStarNode> nodeEntry : open.entrySet()) {
            AStarNode node = nodeEntry.getValue();
            double cost = node.calculateCost(start, end);
            if (cost < lowestCost) {
                lowestCost = node.fCost = cost;
                bestNode = node;
            }
        }

        return bestNode;
    }
}

// gCost = Distance from starting Node
// hCost = Distance from end Node
// fCost = gCost + hCost
class AStarNode {
    class_63 position;
    AStarNode parent;
    double fCost;

    public AStarNode(class_63 position, AStarNode parent) {
        this.position = position;
        this.parent = parent;
        this.fCost = Double.MAX_VALUE;
    }

    public double calculateCost(class_63 start, class_63 end) {
        double gCostT = position.method_1235(start.field_1482, start.field_1483, start.field_1484);
        double hCostT = position.method_1235(end.field_1482, end.field_1483, end.field_1484);
        return gCostT + hCostT;
    }
}
