package net.danygames2014.nyalib.network;

import net.danygames2014.nyalib.NyaLib;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_202;
import net.minecraft.class_63;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@SuppressWarnings({"unused", "UnusedReturnValue"})
public class Network {
    protected HashMap<class_63, NetworkComponentEntry> components;
    public NetworkPathManager pathManager;
    public class_18 world;
    public NetworkType type;
    protected int id;

    public Network(class_18 world, NetworkType type) {
        this.world = world;
        this.type = type;
        components = new HashMap<>();
        pathManager = new NetworkPathManager(this);
    }

    private Network(class_18 world) {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    private Network(NetworkType type) {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    private Network() {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    public boolean isAt(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        return components.containsKey(pos);
    }

    public boolean isAt(class_63 pos) {
        return components.containsKey(pos);
    }

    public NetworkComponentEntry getEntry(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        return components.get(pos);
    }

    public NetworkComponentEntry getEntry(class_63 pos) {
        return components.get(pos);
    }

    /**
     * Get the shortest path between points
     *
     * @param from The point from which to calculate path
     * @param to   The point to which the path should be calculated
     * @return The NetworkPath if it was found. <code>null</code> if it was now
     */
    public NetworkPath getPath(class_63 from, class_63 to) {
        return pathManager.getPath(from, to);
    }

    /**
     * Get the shortest path between network components
     *
     * @param from The component from which to calculate path
     * @param to   The component to which the path should be calculated
     * @return The NetworkPath if it was found. <code>null</code> if it was now
     */
    public NetworkPath getPath(NetworkComponentEntry from, NetworkComponentEntry to) {
        return getPath(from.pos(), to.pos());
    }

    /**
     * Allows you to add a check on paths validity,
     * Keep in mind that the path manager already checks if all components on the path exist
     *
     * @param path The path to validate
     * @return <code>true</code> if the path is valid
     */
    public boolean isPathValid(NetworkPath path) {
        return true;
    }

    public void addBlock(int x, int y, int z, class_17 block, boolean notify) {
        if (block instanceof NetworkComponent component) {
            class_63 pos = new class_63(x, y, z);
            components.put(pos, new NetworkComponentEntry(pos, block, component, new class_8()));
            if (notify) {
                component.onAddedToNet(world, x, y, z, this);
            }
        }
    }

    public boolean removeBlock(int x, int y, int z, boolean notify) {
        class_63 pos = new class_63(x, y, z);
        if (components.containsKey(pos)) {

            if (notify) {
                if (components.get(pos).block() instanceof NetworkComponent component) {
                    component.onRemovedFromNet(world, x, y, z, this);
                }
            }

            components.remove(pos);
            return true;
        }
        return false;
    }

    /**
     * Called before entities/block entities are ticked
     */
    public void tick() {

    }

    /**
     * Called after entities/block entities are ticked
     */
    public void postEntityTick() {

    }

    /**
     * Called on every world tick, which is after entities/block entities are ticked
     */
    public void worldTick() {

    }

    /**
     * Called when there is a change to the network physical topology
     */
    public void update() {
        pathManager.clearCache();
        
        for (Map.Entry<class_63, NetworkComponentEntry> block : components.entrySet()) {
            class_63 pos = block.getKey();

            if (block.getValue().block() instanceof NetworkComponent component) {
                component.update(world, pos.field_1482, pos.field_1483, pos.field_1484, this);
            }
        }
    }

    public ArrayList<class_63> walk(class_63 start) {
        // ArrayList for list of blocks yet to explore
        ArrayList<class_63> open = new ArrayList<>();
        // ArrayList for list of blocks that have been found
        ArrayList<class_63> closed = new ArrayList<>();

        // Add the starting position to explore
        open.add(start);

        // Go until open isnt empty
        while (!open.isEmpty()) {
            // Get the position to explore
            class_63 pos = open.get(0);
            // Look at all of its sides
            for (Direction dir : Direction.values()) {
                // Get the side and see if there is a block on it. Then check if it doesnt already exist
                class_63 side = new class_63(pos.field_1482 + dir.getOffsetX(), pos.field_1483 + dir.getOffsetY(), pos.field_1484 + dir.getOffsetZ());
                if (components.containsKey(side) && !closed.contains(side)) {
                    // Check if the side block can connect to this block and reverse
                    if (getEntry(pos).component().canConnectTo(world, pos.field_1482, pos.field_1483, pos.field_1484, this, dir) && getEntry(side).component().canConnectTo(world, side.field_1482, side.field_1483, side.field_1484, this, dir.getOpposite())) {
                        // Check if the component is an edge, or a node
                        NetworkComponent component = getEntry(side).component();
                        if (component instanceof NetworkNodeComponent) {
                            open.add(side);
                        } else if (component instanceof NetworkEdgeComponent) {
                            closed.add(side);
                        }
                    }
                }
            }

            // Add the position to closed and remove it from open
            closed.add(pos);
            open.remove(pos);
        }

        return closed;
    }

    public void writeNbt(class_8 tag) {

    }

    public void readNbt(class_8 tag) {

    }

    public class_8 toNbt() {
        class_8 tag = new class_8();
        class_202 blocksNbt = new class_202();

        tag.method_1015("id", id);
        tag.method_1017("blocks", blocksNbt);

        for (Map.Entry<class_63, NetworkComponentEntry> entry : components.entrySet()) {
            class_8 blockNbt = new class_8();

            class_63 pos = entry.getKey();
            blockNbt.method_1015("x", pos.field_1482);
            blockNbt.method_1015("y", pos.field_1483);
            blockNbt.method_1015("z", pos.field_1484);

            if (entry.getValue().block() instanceof NetworkComponent component) {
                component.writeNbt(world, pos.field_1482, pos.field_1483, pos.field_1484, this, blockNbt);
            }

            blockNbt.method_1018("entryData", entry.getValue().data());

            blocksNbt.method_1397(blockNbt);
        }

        this.writeNbt(tag);

        return tag;
    }

    public static Network fromNbt(class_8 tag, class_18 world, Identifier networkTypeIdentifier) {
        NetworkType networkType = NetworkTypeRegistry.get(networkTypeIdentifier);

        if (networkType == null) {
            NyaLib.LOGGER.error("Network of type {} not found in registry. Has the modlist been changed? Skipping the loading of this network.", networkTypeIdentifier);
            return null;
        }

        Network network;

        try {
            network = networkType.getNetworkClass().getDeclaredConstructor(class_18.class, NetworkType.class).newInstance(world, networkType);
        } catch (Exception e) {
            NyaLib.LOGGER.error("Error when creating a network of type {}", networkType.getIdentifier(), e);
            return null;
        }

        network.components = new HashMap<>();

        network.id = tag.method_1027("id");
        class_202 blocksNbt = tag.method_1034("blocks");

        // Iterate over all the block NBT Compounds
        for (int i = 0; i < blocksNbt.method_1398(); i++) {
            // Get this block NBT Compound
            class_8 blockNbt = (class_8) blocksNbt.method_1396(i);

            // Fetch the position of the block
            class_63 pos = new class_63(blockNbt.method_1027("x"), blockNbt.method_1027("y"), blockNbt.method_1027("z"));

            // Fetch the type of the block
            class_17 block = world.getBlockState(pos.field_1482, pos.field_1483, pos.field_1484).getBlock();

            // Mod NBT
            if (block instanceof NetworkComponent component) {
                component.readNbt(world, pos.field_1482, pos.field_1483, pos.field_1484, network, blockNbt);

                // Put the block in Network
                network.components.put(
                        pos,
                        new NetworkComponentEntry(pos, block, component, blockNbt.method_1033("entryData"))
                );

                component.onAddedToNet(world, pos.field_1482, pos.field_1483, pos.field_1484, network);
            }
        }

        network.readNbt(tag);

        // Return the loaded network
        return network;
    }

    public int getId() {
        return id;
    }
}
