/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.energy.template.block.entity;

import java.util.HashMap;
import java.util.Map;
import net.danygames2014.nyalib.energy.EnergyConsumer;
import net.danygames2014.nyalib.energy.EnergySource;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.energy.EnergyNetwork;
import net.minecraft.class_18;
import net.minecraft.class_55;
import net.minecraft.class_63;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

public abstract class EnergySourceBlockEntityTemplate
extends class_55
implements EnergySource {
    public int energy;
    public HashMap<EnergyNetwork, Direction> energyNets = new HashMap(2);
    public int extracted = 0;

    public void method_1076() {
        this.extracted = 0;
        if (this.energy > 0) {
            for (Direction side : Direction.values()) {
                class_55 class_552 = this.field_1238.method_1777(this.field_1239 + side.getOffsetX(), this.field_1240 + side.getOffsetY(), this.field_1241 + side.getOffsetZ());
                if (!(class_552 instanceof EnergyConsumer)) continue;
                EnergyConsumer consumer = (EnergyConsumer)class_552;
                int usedPower = consumer.receiveEnergy(side.getOpposite(), this.getOutputVoltage(side), Math.min(this.energy, this.getMaxEnergyOutput(side) - this.extracted));
                this.removeEnergy(usedPower);
                this.extracted += usedPower;
            }
            for (Map.Entry entry : this.energyNets.entrySet()) {
                int usedPower = ((EnergyNetwork)entry.getKey()).provideEnergy(this, new class_63(this.field_1239, this.field_1240, this.field_1241), this.getOutputVoltage((Direction)entry.getValue()), Math.min(this.energy, this.getMaxEnergyOutput(null) - this.extracted));
                this.removeEnergy(usedPower);
                this.extracted += usedPower;
            }
        }
    }

    public void addedToNet(class_18 world, int x, int y, int z, Network network) {
        EnergyNetwork energyNet;
        if (network instanceof EnergyNetwork && !this.energyNets.containsKey(energyNet = (EnergyNetwork)network)) {
            this.energyNets.put(energyNet, this.getNetSide(x, y, z, network));
        }
    }

    public void removedFromNet(class_18 world, int x, int y, int z, Network network) {
        if (network instanceof EnergyNetwork) {
            EnergyNetwork energyNet = (EnergyNetwork)network;
            this.energyNets.remove(energyNet);
        }
    }

    public void update(class_18 world, int x, int y, int z, Network network) {
        EnergyNetwork energyNet;
        if (network instanceof EnergyNetwork && !this.energyNets.containsKey(energyNet = (EnergyNetwork)network)) {
            this.energyNets.put(energyNet, this.getNetSide(x, y, z, network));
        }
    }

    @Nullable
    public Direction getNetSide(int x, int y, int z, Network network) {
        for (Direction side : Direction.values()) {
            if (!network.isAt(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ())) continue;
            return side;
        }
        return null;
    }

    @Override
    public abstract int getMaxOutputVoltage(@Nullable Direction var1);

    @Override
    public abstract int getOutputVoltage(@Nullable Direction var1);

    @Override
    public abstract int getMaxEnergyOutput(@Nullable Direction var1);

    @Override
    public abstract boolean canExtractEnergy(@Nullable Direction var1);

    @Override
    public abstract boolean canConnectEnergy(Direction var1);

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public abstract int getEnergyCapacity();

    @Override
    public int setEnergy(int value) {
        this.energy = value;
        if (this.energy > this.getEnergyCapacity()) {
            this.energy = this.getEnergyCapacity();
        }
        return this.energy;
    }

    @Override
    public int extractEnergy(@Nullable Direction direction, int requestedEnergy) {
        if (!this.canExtractEnergy(direction)) {
            return 0;
        }
        if (this.getEnergyStored() <= 0) {
            return 0;
        }
        if ((requestedEnergy = Math.min(requestedEnergy, this.getMaxEnergyOutput(direction) - this.extracted)) <= 0) {
            return 0;
        }
        int extractedEnergy = this.removeEnergy(requestedEnergy);
        this.extracted += extractedEnergy;
        return extractedEnergy;
    }

    public void method_1078(class_8 nbt) {
        super.method_1078(nbt);
        nbt.method_1015("energy", this.energy);
    }

    public void method_1077(class_8 nbt) {
        super.method_1077(nbt);
        this.energy = nbt.method_1027("energy");
    }
}

