/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network.energy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.energy.EnergyConsumer;
import net.danygames2014.nyalib.energy.EnergySource;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkComponentEntry;
import net.danygames2014.nyalib.network.NetworkEdgeComponent;
import net.danygames2014.nyalib.network.NetworkPath;
import net.danygames2014.nyalib.network.NetworkType;
import net.danygames2014.nyalib.particle.ParticleHelper;
import net.minecraft.class_18;
import net.minecraft.class_55;
import net.minecraft.class_63;
import net.modificationstation.stationapi.api.util.math.Direction;

public class EnergyNetwork
extends Network {
    public HashMap<class_63, ConsumerEntry> consumers = new HashMap();
    public HashMap<class_63, ArrayList<ConsumerPath>> consumerCache = new HashMap();

    public EnergyNetwork(class_18 world, NetworkType type) {
        super(world, type);
    }

    @Override
    public void update() {
        this.consumers.clear();
        this.consumerCache.clear();
        for (NetworkComponentEntry componentEntry : this.components.values()) {
            class_55 class_552;
            if (!(componentEntry.component() instanceof NetworkEdgeComponent) || !((class_552 = this.world.method_1777(componentEntry.pos().field_1482, componentEntry.pos().field_1483, componentEntry.pos().field_1484)) instanceof EnergyConsumer)) continue;
            EnergyConsumer consumer = (EnergyConsumer)class_552;
            this.consumers.put(componentEntry.pos(), new ConsumerEntry(componentEntry, consumer));
        }
        super.update();
    }

    public int provideEnergy(EnergySource source, class_63 sourcePos, int voltage, int power) {
        int remainingPower = power;
        for (ConsumerPath consumerPath : this.getValidConsumers(sourcePos)) {
            int usedPower;
            EnergyConsumer consumer = consumerPath.consumer;
            NetworkPath path = consumerPath.path;
            if (consumer.getRemainingCapacity() <= 0 || (remainingPower -= (usedPower = this.traverseEnergy(consumer, path.endFace, path, voltage, remainingPower))) > 0) continue;
            return power;
        }
        return power - remainingPower;
    }

    private int traverseEnergy(EnergyConsumer consumer, Direction consumerFace, NetworkPath path, int voltage, int remainingPower) {
        for (class_63 node : path.path) {
            ParticleHelper.addParticle(this.world, "flame", (double)node.field_1482 + 0.5, (double)(node.field_1483 + 1), (double)node.field_1484 + 0.5, 0.0, 0.1, 0.0);
        }
        return consumer.receiveEnergy(consumerFace, voltage, remainingPower);
    }

    public ArrayList<ConsumerPath> getValidConsumers(class_63 source) {
        if (this.consumerCache.containsKey(source)) {
            return this.consumerCache.get(source);
        }
        ArrayList<ConsumerPath> consumers = new ArrayList<ConsumerPath>();
        for (Map.Entry<class_63, ConsumerEntry> consumer : this.consumers.entrySet()) {
            if (consumer.getKey().equals((Object)source)) continue;
            NetworkPath path = this.getPath(source, consumer.getKey());
            if (path == null) {
                NyaLib.LOGGER.debug("Path was null when getting valid consumers");
                continue;
            }
            if (!consumer.getValue().consumer.canReceiveEnergy(path.endFace)) continue;
            consumers.add(new ConsumerPath(consumer.getValue().consumer, path));
        }
        this.consumerCache.put(source, consumers);
        return consumers;
    }

    public record ConsumerEntry(NetworkComponentEntry componentEntry, EnergyConsumer consumer) {
    }

    public record ConsumerPath(EnergyConsumer consumer, NetworkPath path) {
    }
}

