package net.danygames2014.nyalib.capability.block.energyhandler;

import net.danygames2014.nyalib.capability.block.BlockCapability;
import net.danygames2014.nyalib.energy.EnergyHandler;
import net.modificationstation.stationapi.api.util.math.Direction;

public abstract class EnergyHandlerBlockCapability extends BlockCapability implements EnergyHandler {
    @Override
    public abstract boolean canConnectEnergy(Direction direction);

    @Override
    public abstract int getEnergyStored();

    @Override
    public abstract int getEnergyCapacity();

    @Override
    public int getRemainingCapacity() {
        return EnergyHandler.super.getRemainingCapacity();
    }

    @Override
    public abstract int setEnergy(int value);

    @Override
    public int changeEnergy(int difference) {
        return EnergyHandler.super.changeEnergy(difference);
    }

    @Override
    public int addEnergy(int amount) {
        return EnergyHandler.super.addEnergy(amount);
    }

    @Override
    public int removeEnergy(int amount) {
        return EnergyHandler.super.removeEnergy(amount);
    }
}
