package net.danygames2014.nyalib.capability.entity.itemhandler;

import net.danygames2014.nyalib.capability.entity.EntityCapability;
import net.danygames2014.nyalib.item.ItemHandler;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

public abstract class ItemHandlerEntityCapability extends EntityCapability implements ItemHandler {
    public abstract boolean canExtractItem();

    public abstract class_31 extractItem(int slot, int amount);

    public class_31 extractItem() {
        return this.extractItem(null);
    }
    
    public class_31 extractItem(class_124 item, int amount) {
        return this.extractItem(item, amount, null);
    }

    public abstract boolean canInsertItem();

    public abstract class_31 insertItem(class_31 stack, int slot);

    public abstract class_31 insertItem(class_31 stack);

    public abstract class_31 getItemInSlot(int slot);

    public abstract int getItemSlots();

    public abstract class_31[] getInventory();

    // The underlying interface
    @Override
    public boolean canExtractItem(@Nullable Direction direction) {
        return this.canExtractItem();
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction direction) {
        return this.extractItem(slot, amount);
    }

    @Override
    public boolean canInsertItem(@Nullable Direction direction) {
        return this.canInsertItem();
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction direction) {
        return this.insertItem(stack, slot);
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction direction) {
        return this.insertItem(stack);
    }

    @Override
    public class_31 getItemInSlot(int slot, @Nullable Direction direction) {
        return this.getItemInSlot(slot);
    }

    @Override
    public int getItemSlots(@Nullable Direction direction) {
        return this.getItemSlots();
    }

    @Override
    public class_31[] getInventory(@Nullable Direction direction) {
        return this.getInventory();
    }

    @Override
    public boolean canConnectItem(Direction direction) {
        return true;
    }
}
