package net.danygames2014.nyalib.capability.entity.itemhandler;

import java.util.ArrayList;
import net.minecraft.class_31;
import net.minecraft.class_54;

public class ItemHandlerPlayerEntityCapability extends ItemHandlerEntityCapability {
    class_54 player;

    public ItemHandlerPlayerEntityCapability(class_54 player) {
        this.player = player;
    }

    @Override
    public boolean canExtractItem() {
        return true;
    }

    @Override
    public class_31 extractItem(int slot, int amount) {
        return player.field_519.method_949(slot, amount);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot) {
        // Check if the current stack is null
        if (player.field_519.method_954(slot) == null) {
            if (stack.field_751 <= player.field_519.method_953()) {
                // If the stack fits into the slot, just set it and return null meaning the stack was inserted entirely
                player.field_519.method_950(slot, stack);
                return null;

            } else if (stack.field_751 > player.field_519.method_953()) {
                // If the stack is too large for the slot, insert a maximum size stack and then return a remainder stack
                player.field_519.method_950(slot, stack);

                class_31 remainderStack = stack.method_724();
                remainderStack.field_751 = stack.field_751 - player.field_519.method_953();
                return remainderStack;
            }
        } else {
            // Check if the existing stack is equal to the one we are trying to insert
            class_31 existingStack = player.field_519.method_954(slot);
            if (existingStack.method_702(stack)) {
                int freeSpace = player.field_519.method_953() - existingStack.field_751;

                // Add to the existing stack, the underlying setStack method will make sure to limit the final amount
                existingStack.field_751 += stack.field_751;
                player.field_519.method_950(slot, existingStack);

                if (freeSpace >= stack.field_751) {
                    // If there is enough space to fit the inserted stack, just add to the stack and return null
                    return null;

                } else {
                    // If there isnt enough space, "fill" the stack up to maximum and return remainder
                    class_31 remainderStack = stack.method_724();
                    remainderStack.field_751 = stack.field_751 - freeSpace;
                    return remainderStack;
                }
            }
        }

        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack) {
        class_31 insertedStack = stack.method_724();

        for (int i = 0; i < player.field_519.method_948(); i++) {
            insertedStack = insertItem(insertedStack, i);

            // If its null, it was inserted entirely, no need to loop furthers
            if (insertedStack == null) {
                return null;
            }
        }

        return insertedStack;
    }

    @Override
    public class_31 getItemInSlot(int slot) {
        return player.field_519.method_954(slot);
    }

    @Override
    public int getItemSlots() {
        return player.field_519.method_948();
    }

    @Override
    public class_31[] getInventory() {
        ArrayList<class_31> inventory = new ArrayList<class_31>(player.field_519.method_948());
        
        for (int i = 0; i < player.field_519.method_948(); i++) {
            inventory.add(player.field_519.method_954(i));
        }
        
        return inventory.toArray(new class_31[0]);
    }
}
