package net.danygames2014.nyalib.particle;

import net.minecraft.class_124;
import net.minecraft.class_18;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.network.packet.PacketHelper;

public class ParticleHelper {
    // Normal particles

    /**
     * Spawn a particle for all players in the given range
     */
    public static void addParticle(class_18 world, String particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ, int range) {
        for (Object playerO : world.field_200) {
            if (playerO instanceof class_54 player) {
                if (player.method_1350(x, y, z) <= range) {
                    addParticle(player, particle, x, y, z, velocityX, velocityY, velocityZ);
                }
            }
        }
    }

    /**
     * Spawn a particle for all players in a range of 32 blocks
     */
    public static void addParticle(class_18 world, String particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        addParticle(world, particle, x, y, z, velocityX, velocityY, velocityZ, 32);
    }

    /**
     * Spawn a particle for all players in a range of 32 blocks with no velocity
     */
    public static void addParticle(class_18 world, String particle, double x, double y, double z) {
        addParticle(world, particle, x, y, z, 0.0D, 0.0D, 0.0D);
    }


    /**
     * Spawn a particle for the given player at the given coordinates
     */
    public static void addParticle(class_54 player, String particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        PacketHelper.sendTo(player, new ParticlePacket(particle, x, y, z, velocityX, velocityY, velocityZ));
    }

    // Item Particles

    /**
     * Spawn a particle for all players in the given range
     */
    public static void addItemParticle(class_18 world, class_124 item, double x, double y, double z, double velocityX, double velocityY, double velocityZ, int range) {
        for (Object playerO : world.field_200) {
            if (playerO instanceof class_54 player) {
                if (player.method_1350(x, y, z) <= range) {
                    addItemParticle(player, item, x, y, z, velocityX, velocityY, velocityZ);
                }
            }
        }
    }

    /**
     * Spawn a particle for all players in a range of 32 blocks
     */
    public static void addItemParticle(class_18 world, class_124 item, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        addItemParticle(world, item, x, y, z, velocityX, velocityY, velocityZ, 32);
    }

    /**
     * Spawn an item particle for the given player at the given coordinates
     */
    public static void addItemParticle(class_54 player, class_124 item, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        PacketHelper.sendTo(player, new ParticlePacket(item, x, y, z, velocityX, velocityY, velocityZ));
    }
}
