package net.danygames2014.nyalib.capability.block.energyhandler;

import net.danygames2014.nyalib.capability.block.BlockCapabilityProvider;
import net.danygames2014.nyalib.energy.EnergyConsumer;
import net.danygames2014.nyalib.energy.EnergyHandler;
import net.danygames2014.nyalib.energy.EnergySource;
import net.minecraft.class_18;
import net.minecraft.class_55;
import org.jetbrains.annotations.Nullable;

public class EnergyHandlerInterfaceBlockCapabilityProvider extends BlockCapabilityProvider<EnergyHandlerBlockCapability> {
    @Override
    public @Nullable EnergyHandlerBlockCapability getCapability(class_18 world, int x, int y, int z) {
        class_55 blockEntity = world.method_1777(x, y, z);
        
        if (blockEntity instanceof EnergyHandler energyHandler) {
            EnergyConsumer energyConsumer = null;
            EnergySource energySource = null;
            
            if (blockEntity instanceof EnergySource source) {
                energySource = source;
            }
            
            if (blockEntity instanceof EnergyConsumer consumer) {
                energyConsumer = consumer;
            }
            
            return new EnergyHandlerInterfaceBlockCapability(energyHandler, energyConsumer, energySource);
        }
        
        return null;
    }
}
