package net.danygames2014.nyalib.capability.block.itemhandler;

import net.minecraft.class_134;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("DuplicatedCode")
class ItemHandlerInventoryBlockCapability extends ItemHandlerBlockCapability {
    private final class_134 inventory;
    
    public ItemHandlerInventoryBlockCapability(class_134 inventory) {
        this.inventory = inventory;
    }

    @Override
    public boolean canConnectItem(Direction direction) {
        return true;
    }

    @Override
    public boolean canExtractItem(@Nullable Direction direction) {
        return true;
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction direction) {
        return inventory.method_949(slot, amount);
    }

    @Override
    public boolean canInsertItem(@Nullable Direction direction) {
        return true;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction direction) {
        class_31 slotStack;

        slotStack = inventory.method_954(slot);

        if (slotStack == null) {
            inventory.method_950(slot, stack);
            return null;
        }

        if (slotStack.method_702(stack)) {
            int addedCount = Math.min(slotStack.method_694().method_459() - slotStack.field_751, stack.field_751);

            slotStack.field_751 += addedCount;

            if (addedCount >= stack.field_751) {
                return null;
            } else {
                return new class_31(stack.method_694(), stack.field_751 - addedCount, stack.method_722());
            }
        }

        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction direction) {
        class_31 insertedStack = stack.method_724();

        for (int i = 0; i < this.getItemSlots(direction); ++i) {
            insertedStack = insertItem(insertedStack, i, direction);
            if (insertedStack == null) {
                return insertedStack;
            }
        }

        return insertedStack;
    }

    @Override
    public class_31 getItemInSlot(int slot, @Nullable Direction direction) {
        return inventory.method_954(slot);
    }

    @Override
    public int getItemSlots(@Nullable Direction direction) {
        return inventory.method_948();
    }

    @Override
    public class_31[] getInventory(@Nullable Direction direction) {
        class_31[] stacks = new class_31[inventory.method_948()];
        
        for (int i = 0; i < inventory.method_948(); i++) {
            stacks[i] = inventory.method_954(i);
        }
        
        return stacks;
    }
}
