package net.danygames2014.nyalib.item;

import net.minecraft.class_124;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

/**
 * An Item Handler interface to be implemented on blocks
 */
@SuppressWarnings("unused")
public interface ItemHandler extends ItemCapable {
    /**
     * Check if the handler supports extracting items on this side, if this returns false there
     * should be no point in trying to use {@link #extractItem(int, int, Direction)}
     *
     * @param direction Direction to check
     * @return <code>true</code> if the device supports item extraction from the given direction
     */
    boolean canExtractItem(@Nullable Direction direction);

    /**
     * Extract an item in the given slot from the handler
     *
     * @param slot      The slot to extract from
     * @param amount    The amount to extract (can be larger than the maximum stack size)
     * @param direction The direction to extract from
     * @return The ItemStack extracted, null if nothing is extracted
     */
    class_31 extractItem(int slot, int amount, @Nullable Direction direction);


    /**
     * Extract any item from the given direction
     *
     * @param direction The direction to extract from
     * @return The extracted ItemStack
     */
    default class_31 extractItem(@Nullable Direction direction) {
        for (int i = 0; i < getItemSlots(direction); i++) {
            if (getItemInSlot(i, direction) != null) {
                return extractItem(i, Integer.MAX_VALUE, direction);
            }
        }
        return null;
    }


    /**
     * Extract the given item in any slot from the handler
     *
     * @param item      The Item to extract
     * @param amount    The amount to extract (can be larger than the maximum stack size)
     * @param direction The direction to extract from
     * @return The ItemStack extracted, null if nothing is extracted
     */
    default class_31 extractItem(class_124 item, int amount, @Nullable Direction direction) {
        class_31 currentStack = null;
        int remaining = amount;

        for (int i = 0; i < getItemSlots(direction); i++) {
            if (remaining <= 0) {
                break;
            }

            if (currentStack != null) {
                if (this.getItemInSlot(i, direction).method_702(currentStack)) {
                    class_31 extractedStack = extractItem(i, remaining, direction);
                    remaining -= extractedStack.field_751;
                    currentStack.field_751 += extractedStack.field_751;
                }
            } else {
                if (getItemInSlot(i, direction).isOf(item)) {
                    class_31 extractedStack = extractItem(i, remaining, direction);
                    remaining -= extractedStack.field_751;
                    currentStack = extractedStack;
                }
            }
        }

        return currentStack;
    }

    /**
     * Check if the handler supports inserting items on this side, if this returns false there
     * should be no point in trying to use {@link #insertItem(class_31, Direction)} or {@link #insertItem(class_31, int, Direction)}
     *
     * @param direction Direction to check
     * @return <code>true</code> if the device supports item insertion from the given direction
     */
    boolean canInsertItem(@Nullable Direction direction);

    /**
     * Insert item into the given slot and return the remainder
     *
     * @param stack     The {@link class_31} to insert
     * @param slot      Slot to insert into
     * @param direction Direction to insert from
     * @return The remainder of the ItemStack (null if it was inserted entirely), this should be a new ItemStack, however it can be the same if it was not modified
     */
    class_31 insertItem(class_31 stack, int slot, @Nullable Direction direction);

    /**
     * Insert item into any slot and return the remainder
     *
     * @param stack     The {@link class_31} to insert
     * @param direction Direction to insert from
     * @return The remainder of the ItemStack (null if it was inserted entirely), this should be a new ItemStack, however it can be the same if it was not modified
     */
    class_31 insertItem(class_31 stack, @Nullable Direction direction);

    /**
     * Get the {@link class_31} in the given slot, If there is no {@link class_31}, then return null
     * <p>
     *
     * @param slot      The slot to get the {@link class_31} from
     * @param direction The direction to query from
     * @return The {@link class_31} in the slot
     */
    class_31 getItemInSlot(int slot, @Nullable Direction direction);
    // TODO: rename to getItem ?
    
    // TODO: setItem
    
    /**
     * Get the size of the handler inventory
     *
     * @param direction The direction to get the size from
     * @return The number of slots this handler has
     */
    int getItemSlots(@Nullable Direction direction);

    /**
     * Get the entire inventory of the handler
     *
     * @param direction The direction to get the inventory from
     * @return An array of all the ItemStacks
     */
    class_31[] getInventory(@Nullable Direction direction);
}
