package net.danygames2014.nyalib.item;

import net.minecraft.class_124;
import net.minecraft.class_31;

/**
 * An Item Handler interface to be implemented on entities
 */
@SuppressWarnings("unused")
public interface ItemHandlerEntity extends ItemCapable {
    /**
     * Check if the handler supports extracting items, if this returns false there
     * should be no point in trying to use {@link #extractItem(int, int)}
     *
     * @return <code>true</code> if the entity supports item extraction
     */
    boolean canExtractItem();

    /**
     * Extract an item in the given slot from the handler
     *
     * @param slot   The slot to extract from
     * @param amount The amount to extract (can be larger than the maximum stack size)
     * @return The ItemStack extracted, null if nothing is extracted
     */
    class_31 extractItem(int slot, int amount);


    /**
     * Extract any item
     *
     * @return The extracted ItemStack
     */
    default class_31 extractItem() {
        for (int i = 0; i < getItemSlots(); i++) {
            if (getItemInSlot(i) != null) {
                return extractItem(i, Integer.MAX_VALUE);
            }
        }
        return null;
    }


    /**
     * Extract the given item in any slot
     *
     * @param item   The Item to extract
     * @param amount The amount to extract (can be larger than the maximum stack size)
     * @return The ItemStack extracted, null if nothing is extracted
     */
    default class_31 extractItem(class_124 item, int amount) {
        class_31 currentStack = null;
        int remaining = amount;

        for (int i = 0; i < getItemSlots(); i++) {
            if (remaining <= 0) {
                break;
            }

            if (currentStack != null) {
                if (this.getItemInSlot(i).method_702(currentStack)) {
                    class_31 extractedStack = extractItem(i, remaining);
                    remaining -= extractedStack.field_751;
                    currentStack.field_751 += extractedStack.field_751;
                }
            } else {
                if (getItemInSlot(i).isOf(item)) {
                    class_31 extractedStack = extractItem(i, remaining);
                    remaining -= extractedStack.field_751;
                    currentStack = extractedStack;
                }
            }
        }

        return currentStack;
    }

    /**
     * Check if the handler supports inserting items, if this returns false there
     * should be no point in trying to use {@link #insertItem(class_31)} or {@link #insertItem(class_31, int)}
     *
     * @return <code>true</code> if the entity supports item insertion
     */
    boolean canInsertItem();

    /**
     * Insert item into the given slot and return the remainder
     *
     * @param stack     The {@link class_31} to insert
     * @param slot      Slot to insert into
     * @return The remainder of the ItemStack (null if it was inserted entirely), this should be a new ItemStack, however it can be the same if it was not modified
     */
    class_31 insertItem(class_31 stack, int slot);

    /**
     * Insert item into any slot and return the remainder
     *
     * @param stack     The {@link class_31} to insert
     * @return The remainder of the ItemStack (null if it was inserted entirely), this should be a new ItemStack, however it can be the same if it was not modified
     */
    class_31 insertItem(class_31 stack);

    /**
     * Get the {@link class_31} in the given slot, If there is no {@link class_31}, then return null
     * <p>
     *
     * @param slot The slot to get the {@link class_31} from
     * @return The {@link class_31} in the slot
     */
    class_31 getItemInSlot(int slot);

    /**
     * Get the size of the handler inventory
     *
     * @return The number of slots this handler has
     */
    int getItemSlots();

    /**
     * Get the entire inventory of the handler
     *
     * @return An array of all the ItemStacks
     */
    class_31[] getInventory();
}
