/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.capability.block.energyhandler;

import net.danygames2014.nyalib.capability.block.energyhandler.EnergyHandlerBlockCapability;
import net.danygames2014.nyalib.energy.EnergyConsumer;
import net.danygames2014.nyalib.energy.EnergyHandler;
import net.danygames2014.nyalib.energy.EnergySource;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

class EnergyHandlerInterfaceBlockCapability
extends EnergyHandlerBlockCapability {
    private final EnergyHandler energyHandler;
    private final EnergyConsumer energyConsumer;
    private final EnergySource energySource;

    public EnergyHandlerInterfaceBlockCapability(EnergyHandler energyHandler, EnergyConsumer energyConsumer, EnergySource energySource) {
        this.energyHandler = energyHandler;
        this.energyConsumer = energyConsumer;
        this.energySource = energySource;
    }

    @Override
    public boolean canConnectEnergy(Direction direction) {
        return this.energyHandler.canConnectEnergy(direction);
    }

    @Override
    public int getEnergyStored() {
        return this.energyHandler.getEnergyStored();
    }

    @Override
    public int getEnergyCapacity() {
        return this.energyHandler.getEnergyCapacity();
    }

    @Override
    public int getRemainingCapacity() {
        return this.energyHandler.getRemainingCapacity();
    }

    @Override
    public int setEnergy(int value) {
        return this.energyHandler.setEnergy(value);
    }

    @Override
    public int changeEnergy(int difference) {
        return this.energyHandler.changeEnergy(difference);
    }

    @Override
    public int addEnergy(int amount) {
        return this.energyHandler.addEnergy(amount);
    }

    @Override
    public int removeEnergy(int amount) {
        return this.energyHandler.removeEnergy(amount);
    }

    @Override
    public int getMaxInputVoltage(@Nullable Direction direction) {
        if (this.energyConsumer != null) {
            return this.energyConsumer.getMaxInputVoltage(direction);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyInput(@Nullable Direction direction) {
        if (this.energyConsumer != null) {
            return this.energyConsumer.getMaxEnergyInput(direction);
        }
        return 0;
    }

    @Override
    public boolean canReceiveEnergy(@Nullable Direction direction) {
        if (this.energyConsumer != null) {
            return this.energyConsumer.canReceiveEnergy(direction);
        }
        return false;
    }

    @Override
    public int receiveEnergy(@Nullable Direction direction, int voltage, int energy) {
        if (this.energyConsumer != null) {
            return this.energyConsumer.receiveEnergy(direction, voltage, energy);
        }
        return 0;
    }

    @Override
    public void onOvervoltage(@Nullable Direction direction, double voltage) {
        if (this.energyConsumer != null) {
            this.energyConsumer.onOvervoltage(direction, voltage);
        }
    }

    @Override
    public int getMaxOutputVoltage(@Nullable Direction direction) {
        if (this.energySource != null) {
            return this.energySource.getMaxOutputVoltage(direction);
        }
        return 0;
    }

    @Override
    public int getOutputVoltage(@Nullable Direction direction) {
        if (this.energySource != null) {
            return this.energySource.getOutputVoltage(direction);
        }
        return 0;
    }

    @Override
    public int getMaxEnergyOutput(@Nullable Direction direction) {
        if (this.energySource != null) {
            return this.energySource.getMaxEnergyOutput(direction);
        }
        return 0;
    }

    @Override
    public boolean canExtractEnergy(@Nullable Direction direction) {
        if (this.energySource != null) {
            return this.energySource.canExtractEnergy(direction);
        }
        return false;
    }

    @Override
    public int extractEnergy(@Nullable Direction direction, int requestedEnergy) {
        if (this.energySource != null) {
            return this.energySource.extractEnergy(direction, requestedEnergy);
        }
        return 0;
    }
}

