/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.energy;

import net.minecraft.class_31;

public interface EnergyStorageItem {
    public int getEnergyStored(class_31 var1);

    public int getEnergyCapacity(class_31 var1);

    default public int getRemainingCapacity(class_31 stack) {
        return this.getEnergyCapacity(stack) - this.getEnergyStored(stack);
    }

    public int setEnergy(class_31 var1, int var2);

    default public int changeEnergy(class_31 stack, int difference) {
        int prevEnergy = this.getEnergyStored(stack);
        int desiredEnergy = prevEnergy + difference;
        if (desiredEnergy > this.getEnergyCapacity(stack)) {
            this.setEnergy(stack, this.getEnergyCapacity(stack));
        } else if (desiredEnergy < 0) {
            this.setEnergy(stack, 0);
        } else {
            this.setEnergy(stack, desiredEnergy);
        }
        int newEnergy = this.getEnergyStored(stack);
        return newEnergy - prevEnergy;
    }

    default public int addEnergy(class_31 stack, int amount) {
        return this.changeEnergy(stack, amount);
    }

    default public int removeEnergy(class_31 stack, int amount) {
        return Math.abs(this.changeEnergy(stack, -amount));
    }

    public boolean canReceiveEnergy(class_31 var1);

    public int getMaxEnergyInput(class_31 var1);

    default public int receiveEnergy(class_31 stack, int energy) {
        if (energy <= 0) {
            return 0;
        }
        if (this.getRemainingCapacity(stack) <= 0) {
            return 0;
        }
        return this.addEnergy(stack, Math.min(energy, this.getMaxEnergyInput(stack)));
    }

    public boolean canExtractEnergy(class_31 var1);

    public int getMaxEnergyOutput(class_31 var1);

    default public int extractEnergy(class_31 stack, int requestedEnergy) {
        if (!this.canExtractEnergy(stack)) {
            return 0;
        }
        if (this.getEnergyStored(stack) <= 0) {
            return 0;
        }
        return this.removeEnergy(stack, Math.min(requestedEnergy, this.getMaxEnergyOutput(stack)));
    }
}

