package net.danygames2014.nyalib.network;

import com.google.common.collect.Sets;
import net.danygames2014.nyalib.NyaLib;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_202;
import net.minecraft.class_63;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

import java.util.*;

@SuppressWarnings("unused")
public class Network {
    protected HashMap<class_63, class_17> blocks;
    public class_18 world;
    public NetworkType type;
    protected int id;

    public Network(class_18 world, NetworkType type) {
        this.world = world;
        this.type = type;
        blocks = new HashMap<>();
    }

    private Network(class_18 world) {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    private Network(NetworkType type) {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    private Network() {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    public boolean isAt(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        return blocks.containsKey(pos);
    }

    public void addBlock(int x, int y, int z, class_17 block) {
        blocks.put(new class_63(x, y, z), block);

        if (block instanceof NetworkComponent component) {
            component.onAddedToNet(world, x, y, z, this);
        }
    }

    public boolean removeBlock(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        if (blocks.containsKey(pos)) {

            if (blocks.get(pos) instanceof NetworkComponent component) {
                component.onRemovedFromNet(world, x, y, z, this);
            }

            blocks.remove(pos);
            return true;
        }
        return false;
    }

    /**
     * Called on every world tick
     */
    public void tick() {

    }

    /**
     * Called when there is a change to the network physical topology
     */
    public void update() {
        for (Map.Entry<class_63, class_17> block : blocks.entrySet()) {
            class_63 pos = block.getKey();

            if (block.getValue() instanceof NetworkComponent component) {
                component.update(world, pos.field_1482, pos.field_1483, pos.field_1484, this);
            }
        }
    }

    /**
     * @param start The position to start walking from
     * @return A list of blocks discovered
     * @author paulevs
     */
    public HashSet<class_63> walk(class_63 start) {
        ArrayList<Set<class_63>> edges = new ArrayList<>();
        HashSet<class_63> result = new HashSet<>();

        edges.add(Sets.newHashSet(start));
        edges.add(Sets.newHashSet());

        byte n = 0;
        boolean added = true;
        while (added) {
            Set<class_63> oldEdge = edges.get(n & 1);
            Set<class_63> newEdge = edges.get((n + 1) & 1);
            n = (byte) ((n + 1) & 1);
            oldEdge.forEach(pos -> {
                for (Direction dir : Direction.values()) {
                    class_63 side = new class_63(pos.field_1482 + dir.getOffsetX(), pos.field_1483 + dir.getOffsetY(), pos.field_1484 + dir.getOffsetZ());
                    if (blocks.containsKey(side) && !result.contains(side)) {
                        newEdge.add(side);
                    }
                }
            });
            added = !oldEdge.isEmpty();
            result.addAll(oldEdge);
            oldEdge.clear();
        }

        return result;
    }

    public void writeNbt(class_8 tag) {

    }

    public void readNbt(class_8 tag) {

    }

    public class_8 toNbt() {
        class_8 tag = new class_8();
        class_202 blocksNbt = new class_202();

        tag.method_1015("id", id);
        tag.method_1017("blocks", blocksNbt);

        for (Map.Entry<class_63, class_17> block : blocks.entrySet()) {
            class_8 blockNbt = new class_8();

            class_63 pos = block.getKey();
            blockNbt.method_1015("x", pos.field_1482);
            blockNbt.method_1015("y", pos.field_1483);
            blockNbt.method_1015("z", pos.field_1484);

            if (block.getValue() instanceof NetworkComponent component) {
                component.writeNbt(world, pos.field_1482, pos.field_1483, pos.field_1484, this, blockNbt);
            }

            blocksNbt.method_1397(blockNbt);
        }

        this.writeNbt(tag);

        return tag;
    }

    public static Network fromNbt(class_8 tag, class_18 world, Identifier networkTypeIdentifier) {
        NetworkType networkType = NetworkTypeRegistry.get(networkTypeIdentifier);

        if (networkType == null) {
            NyaLib.LOGGER.error("Network of type {} not found in registry. Has the modlist been changed? Skipping the loading of this network.", networkTypeIdentifier);
            return null;
        }

        Network network;

        try {
            network = networkType.getNetworkClass().getDeclaredConstructor(class_18.class, NetworkType.class).newInstance(world, networkType);
        } catch (Exception e) {
            NyaLib.LOGGER.error("Error when creating a network of type {}", networkType.getIdentifier(), e);
            return null;
        }

        network.blocks = new HashMap<>();

        network.id = tag.method_1027("id");
        class_202 blocksNbt = tag.method_1034("blocks");

        // Iterate over all the block NBT Compounds
        for (int i = 0; i < blocksNbt.method_1398(); i++) {
            // Get this block NBT Compound
            class_8 blockNbt = (class_8) blocksNbt.method_1396(i);

            // Fetch the position of the block
            class_63 pos = new class_63(blockNbt.method_1027("x"), blockNbt.method_1027("y"), blockNbt.method_1027("z"));

            // Fetch the type of the block
            class_17 block = world.getBlockState(pos.field_1482, pos.field_1483, pos.field_1484).getBlock();

            // Mod NBT
            if (block instanceof NetworkComponent component) {
                component.readNbt(world, pos.field_1482, pos.field_1483, pos.field_1484, network, blockNbt);
            }

            // Put the block in Network
            network.blocks.put(
                    pos,
                    block
            );
        }

        network.readNbt(tag);

        // Return the loaded network
        return network;
    }

    public int getId() {
        return id;
    }
}
