package net.danygames2014.nyalib.network;

import net.danygames2014.nyalib.NyaLib;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_8;
import net.minecraft.class_83;
import net.modificationstation.stationapi.api.event.world.WorldEvent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

@SuppressWarnings("unused")
public class NetworkLoader {

    public static boolean readOnly = false;

    @EventListener
    public void saveNetworks(WorldEvent.Save event) {
        NyaLib.LOGGER.debug("Saving NyaLib networks");

        if (readOnly) {
            NyaLib.LOGGER.warn("Saving NyaLib networks prevented as they are read-only due to error when loading.");
        }

        try {
            File file = event.world.field_219.method_1736("nyalib_networks");

            class_8 tag = new class_8();
            if (file.exists()) {
                tag = class_83.method_338(new FileInputStream(file));
            }

            tag.method_1015("next_id", NetworkManager.NEXT_ID.get());
            NetworkManager.writeNbt(event.world, tag);

            class_83.method_336(tag, new FileOutputStream(file));
            NyaLib.LOGGER.debug("Saved NyaLib networks");
        } catch (Exception e) {
            NyaLib.LOGGER.error("Error occured while saving NyaLib Networks", e);
        }
    }

    @EventListener
    public void loadNetworks(WorldEvent.Init event) {
        NyaLib.LOGGER.debug("Loading NyaLib networks");
        try {
            File file = event.world.field_219.method_1736("nyalib_networks");
            if (file.exists()) {
                class_8 tag = class_83.method_338(new FileInputStream(file));

                NetworkManager.NEXT_ID.set(tag.method_1027("next_id"));
                NetworkManager.readNbt(event.world, tag);

                NyaLib.LOGGER.info("Loaded NyaLib networks");
            }
        } catch (Exception e) {
            NyaLib.LOGGER.error("Error occured while loading NyaLib Networks, networks are now read only to prevent saving corrupted data", e);
            readOnly = true;
        }
    }
}
