/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.network.NetworkComponent;
import net.danygames2014.nyalib.network.NetworkType;
import net.danygames2014.nyalib.network.NetworkTypeRegistry;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_187;
import net.minecraft.class_202;
import net.minecraft.class_63;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class Network {
    protected HashMap<class_63, class_17> blocks;
    public class_18 world;
    public NetworkType type;
    protected int id;

    public Network(class_18 world, NetworkType type) {
        this.world = world;
        this.type = type;
        this.blocks = new HashMap();
    }

    private Network(class_18 world) {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    private Network(NetworkType type) {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    private Network() {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    public boolean isAt(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        return this.blocks.containsKey(pos);
    }

    public void addBlock(int x, int y, int z, class_17 block) {
        this.blocks.put(new class_63(x, y, z), block);
        if (block instanceof NetworkComponent) {
            NetworkComponent component = (NetworkComponent)block;
            component.onAddedToNet(this.world, x, y, z, this);
        }
    }

    public boolean removeBlock(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        if (this.blocks.containsKey(pos)) {
            class_17 class_172 = this.blocks.get(pos);
            if (class_172 instanceof NetworkComponent) {
                NetworkComponent component = (NetworkComponent)class_172;
                component.onRemovedFromNet(this.world, x, y, z, this);
            }
            this.blocks.remove(pos);
            return true;
        }
        return false;
    }

    public void tick() {
    }

    public void update() {
        for (Map.Entry<class_63, class_17> block : this.blocks.entrySet()) {
            class_63 pos = block.getKey();
            class_17 class_172 = block.getValue();
            if (!(class_172 instanceof NetworkComponent)) continue;
            NetworkComponent component = (NetworkComponent)class_172;
            component.update(this.world, pos.field_1482, pos.field_1483, pos.field_1484, this);
        }
    }

    public HashSet<class_63> walk(class_63 start) {
        ArrayList<HashSet> edges = new ArrayList<HashSet>();
        HashSet<class_63> result = new HashSet<class_63>();
        edges.add(Sets.newHashSet((Object[])new class_63[]{start}));
        edges.add(Sets.newHashSet());
        int n = 0;
        boolean added = true;
        while (added) {
            Set oldEdge = (Set)edges.get(n & 1);
            Set newEdge = (Set)edges.get(n + 1 & 1);
            n = (byte)(n + 1 & 1);
            oldEdge.forEach(pos -> {
                for (Direction dir : Direction.values()) {
                    class_63 side = new class_63(pos.field_1482 + dir.getOffsetX(), pos.field_1483 + dir.getOffsetY(), pos.field_1484 + dir.getOffsetZ());
                    if (!this.blocks.containsKey(side) || result.contains(side)) continue;
                    newEdge.add(side);
                }
            });
            added = !oldEdge.isEmpty();
            result.addAll(oldEdge);
            oldEdge.clear();
        }
        return result;
    }

    public void writeNbt(class_8 tag) {
    }

    public void readNbt(class_8 tag) {
    }

    public class_8 toNbt() {
        class_8 tag = new class_8();
        class_202 blocksNbt = new class_202();
        tag.method_1015("id", this.id);
        tag.method_1017("blocks", (class_187)blocksNbt);
        for (Map.Entry<class_63, class_17> block : this.blocks.entrySet()) {
            class_8 blockNbt = new class_8();
            class_63 pos = block.getKey();
            blockNbt.method_1015("x", pos.field_1482);
            blockNbt.method_1015("y", pos.field_1483);
            blockNbt.method_1015("z", pos.field_1484);
            class_17 class_172 = block.getValue();
            if (class_172 instanceof NetworkComponent) {
                NetworkComponent component = (NetworkComponent)class_172;
                component.writeNbt(this.world, pos.field_1482, pos.field_1483, pos.field_1484, this, blockNbt);
            }
            blocksNbt.method_1397((class_187)blockNbt);
        }
        this.writeNbt(tag);
        return tag;
    }

    public static Network fromNbt(class_8 tag, class_18 world, Identifier networkTypeIdentifier) {
        Network network;
        NetworkType networkType = NetworkTypeRegistry.get(networkTypeIdentifier);
        if (networkType == null) {
            NyaLib.LOGGER.error("Network of type {} not found in registry. Has the modlist been changed? Skipping the loading of this network.", (Object)networkTypeIdentifier);
            return null;
        }
        try {
            network = networkType.getNetworkClass().getDeclaredConstructor(class_18.class, NetworkType.class).newInstance(world, networkType);
        }
        catch (Exception e) {
            NyaLib.LOGGER.error("Error when creating a network of type {}", (Object)networkType.getIdentifier(), (Object)e);
            return null;
        }
        network.blocks = new HashMap();
        network.id = tag.method_1027("id");
        class_202 blocksNbt = tag.method_1034("blocks");
        for (int i = 0; i < blocksNbt.method_1398(); ++i) {
            class_8 blockNbt = (class_8)blocksNbt.method_1396(i);
            class_63 pos = new class_63(blockNbt.method_1027("x"), blockNbt.method_1027("y"), blockNbt.method_1027("z"));
            class_17 block = world.getBlockState(pos.field_1482, pos.field_1483, pos.field_1484).getBlock();
            if (block instanceof NetworkComponent) {
                NetworkComponent component = (NetworkComponent)block;
                component.readNbt(world, pos.field_1482, pos.field_1483, pos.field_1484, network, blockNbt);
            }
            network.blocks.put(pos, block);
        }
        network.readNbt(tag);
        return network;
    }

    public int getId() {
        return this.id;
    }
}

