/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.util.ArrayList;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkManager;
import net.danygames2014.nyalib.network.NetworkType;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_8;

public interface NetworkComponent {
    public NetworkType getNetworkType();

    default public ArrayList<NetworkType> getNetworkTypes() {
        ArrayList<NetworkType> types = new ArrayList<NetworkType>();
        types.add(this.getNetworkType());
        return types;
    }

    default public void update(class_18 world, int x, int y, int z, Network network) {
    }

    default public void onAddedToNet(class_18 world, int x, int y, int z, Network network) {
    }

    default public void onRemovedFromNet(class_18 world, int x, int y, int z, Network network) {
    }

    default public <T extends class_17> void addToNet(class_18 world, int x, int y, int z, T component) {
        NetworkManager.addBlock(world, x, y, z, component);
    }

    default public <T extends class_17> void removeFromNet(class_18 world, int x, int y, int z, T component) {
        NetworkManager.removeBlock(world, x, y, z, component);
    }

    default public void writeNbt(class_18 world, int x, int y, int z, Network network, class_8 nbt) {
    }

    default public void readNbt(class_18 world, int x, int y, int z, Network network, class_8 nbt) {
    }
}

