/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkComponent;
import net.danygames2014.nyalib.network.NetworkType;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_50;
import net.minecraft.class_63;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.registry.DimensionRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class NetworkManager {
    public static HashMap<class_50, HashMap<Identifier, ArrayList<Network>>> NETWORKS = new HashMap();
    public static AtomicInteger NEXT_ID = new AtomicInteger(0);
    public static ArrayList<Network> removeQueue = new ArrayList();

    public static ArrayList<Network> getNetworks(class_50 dimension, Identifier networkTypeIdentifier) {
        HashMap<Identifier, ArrayList<Network>> netDims = NETWORKS.get(dimension);
        if (netDims == null) {
            return new ArrayList<Network>();
        }
        ArrayList nets = netDims.get(networkTypeIdentifier);
        return nets != null ? nets : new ArrayList();
    }

    public static HashMap<Identifier, ArrayList<Network>> getNetworks(class_50 dimension) {
        return NETWORKS.get(dimension);
    }

    public static void addNetwork(class_50 dimension, Network network) {
        ArrayList<Network> typeNetworks;
        HashMap<Object, ArrayList<Network>> dimNetworks = NETWORKS.get(dimension);
        if (network == null) {
            return;
        }
        if (dimNetworks == null) {
            dimNetworks = new HashMap();
            NETWORKS.put(dimension, dimNetworks);
        }
        if ((typeNetworks = dimNetworks.get(network.type.getIdentifier())) == null) {
            typeNetworks = new ArrayList();
            dimNetworks.put(network.type.getIdentifier(), typeNetworks);
        }
        typeNetworks.add(network);
    }

    public static Network createNetwork(class_50 dimension, NetworkType networkType) {
        Network network;
        try {
            network = networkType.getNetworkClass().getDeclaredConstructor(class_18.class, NetworkType.class).newInstance(dimension.field_2173, networkType);
        }
        catch (Exception e) {
            NyaLib.LOGGER.error("Error when creating a network of type {}", (Object)networkType.getIdentifier(), (Object)e);
            return null;
        }
        network.id = NEXT_ID.getAndIncrement();
        NetworkManager.addNetwork(dimension, network);
        return network;
    }

    public static void removeNetwork(Network network) {
        if (!removeQueue.contains(network)) {
            removeQueue.add(network);
        }
    }

    public static void removeQueuedNetworks() {
        for (Network toremove : removeQueue) {
            NetworkManager.removeNetworkInternal(toremove);
        }
    }

    private static boolean removeNetworkInternal(Network toRemove) {
        for (Map.Entry<class_50, HashMap<Identifier, ArrayList<Network>>> dimensions : NETWORKS.entrySet()) {
            for (Map.Entry<Identifier, ArrayList<Network>> networks : dimensions.getValue().entrySet()) {
                for (Network network : networks.getValue()) {
                    if (network != toRemove) continue;
                    networks.getValue().remove(network);
                    return true;
                }
            }
        }
        return false;
    }

    public static Network getAt(class_50 dimension, int x, int y, int z, Identifier networkTypeIdentifier) {
        for (Network net : NetworkManager.getNetworks(dimension, networkTypeIdentifier)) {
            if (!net.isAt(x, y, z)) continue;
            return net;
        }
        return null;
    }

    public static ArrayList<Network> getNeighbors(class_18 world, int x, int y, int z) {
        ArrayList<Network> neighborNets = new ArrayList<Network>();
        for (ArrayList<Network> networksOfType : NetworkManager.getNetworks(world.field_216).values()) {
            for (Network network : networksOfType) {
                for (Direction direction : Direction.values()) {
                    if (!network.isAt(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ())) continue;
                    neighborNets.add(network);
                }
            }
        }
        return neighborNets;
    }

    public static ArrayList<Network> getNeighbors(class_18 world, int x, int y, int z, Identifier networkTypeIdentifier) {
        ArrayList<Network> neighborNets = new ArrayList<Network>();
        for (Network network : NetworkManager.getNetworks(world.field_216, networkTypeIdentifier)) {
            for (Direction direction : Direction.values()) {
                if (!network.isAt(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ())) continue;
                neighborNets.add(network);
            }
        }
        return neighborNets;
    }

    public static <T extends class_17> void addBlock(class_18 world, int x, int y, int z, T component) {
        if (component == null) {
            return;
        }
        for (NetworkType networkType : ((NetworkComponent)component).getNetworkTypes()) {
            Network network;
            ArrayList<Network> neighborNets = new ArrayList<Network>(2);
            ArrayList<Network> potentialNets = new ArrayList<Network>();
            potentialNets.addAll(NetworkManager.getNetworks(world.field_216, networkType.getIdentifier()));
            for (Network potentialNet : potentialNets) {
                for (Direction direction : Direction.values()) {
                    if (!potentialNet.isAt(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ())) continue;
                    neighborNets.add(potentialNet);
                }
            }
            switch (neighborNets.size()) {
                case 0: {
                    network = NetworkManager.createNetwork(world.field_216, networkType);
                    break;
                }
                case 1: {
                    network = (Network)neighborNets.get(0);
                    break;
                }
                default: {
                    network = (Network)neighborNets.get(0);
                    for (int i = 1; i < neighborNets.size(); ++i) {
                        if (((Network)neighborNets.get(i)).getId() == network.getId()) continue;
                        network.blocks.putAll(((Network)neighborNets.get((int)i)).blocks);
                        ((Network)neighborNets.get((int)i)).blocks.clear();
                        NetworkManager.removeNetwork((Network)neighborNets.get(i));
                    }
                }
            }
            if (network == null) continue;
            network.addBlock(x, y, z, component);
            network.update();
        }
    }

    public static <T extends class_17> void removeBlock(class_18 world, int x, int y, int z, T component) {
        block8: for (NetworkType networkType : ((NetworkComponent)component).getNetworkTypes()) {
            Network net = NetworkManager.getAt(world.field_216, x, y, z, networkType.getIdentifier());
            if (net == null) {
                NyaLib.LOGGER.warn("Removed a block at [x={}, y={}, z={}] which was not in any network of type {}.", (Object)x, (Object)y, (Object)z, (Object)networkType.toString());
                continue;
            }
            ArrayList<class_63> neighborBlocks = new ArrayList<class_63>();
            for (Direction direction : Direction.values()) {
                class_63 neighborPos = new class_63(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ());
                if (!net.isAt(neighborPos.field_1482, neighborPos.field_1483, neighborPos.field_1484)) continue;
                neighborBlocks.add(neighborPos);
            }
            NyaLib.LOGGER.debug("NET SIZE: {} | NEIGHBORS FOUND : {}", (Object)net.blocks.size(), (Object)neighborBlocks.size());
            switch (neighborBlocks.size()) {
                case 0: {
                    NyaLib.LOGGER.debug("Last block in network, removing network with ID {}", (Object)net.getId());
                    net.removeBlock(x, y, z);
                    if (net.blocks.isEmpty()) {
                        NetworkManager.removeNetwork(net);
                        continue block8;
                    }
                    NyaLib.LOGGER.warn("Removed a block from network {} with no neighbors but the network still has {} blocks. Network will not be deleted", (Object)net.getId(), (Object)net.blocks.size());
                    continue block8;
                }
                case 1: {
                    NyaLib.LOGGER.debug("Only one neighbor, its a stump and can be removed normally");
                    net.removeBlock(x, y, z);
                    continue block8;
                }
            }
            net.removeBlock(x, y, z);
            ArrayList<HashSet<class_63>> potentialNetworks = new ArrayList<HashSet<class_63>>(6);
            for (Direction dir : Direction.values()) {
                class_63 neighbor = new class_63(x + dir.getOffsetX(), y + dir.getOffsetY(), z + dir.getOffsetZ());
                if (!net.isAt(neighbor.field_1482, neighbor.field_1483, neighbor.field_1484)) continue;
                HashSet<class_63> discovered = net.walk(neighbor);
                NyaLib.LOGGER.debug("Discovered a potential network of {} blocks", (Object)discovered.size());
                boolean exists = false;
                for (HashSet hashSet : potentialNetworks) {
                    if (!hashSet.contains(discovered.iterator().next())) continue;
                    exists = true;
                }
                if (exists) continue;
                potentialNetworks.add(discovered);
            }
            NyaLib.LOGGER.debug("There will be {} new networks", (Object)potentialNetworks.size());
            switch (potentialNetworks.size()) {
                case 0: {
                    NyaLib.LOGGER.warn("There were 0 potential networks when splitting, this shouldn't happen");
                    continue block8;
                }
                case 1: {
                    continue block8;
                }
            }
            for (int i = 1; i < potentialNetworks.size(); ++i) {
                Network newNetwork = NetworkManager.createNetwork(world.field_216, networkType);
                for (class_63 pos : (HashSet)potentialNetworks.get(i)) {
                    net.removeBlock(pos.field_1482, pos.field_1483, pos.field_1484);
                    newNetwork.addBlock(pos.field_1482, pos.field_1483, pos.field_1484, world.getBlockState(pos.field_1482, pos.field_1483, pos.field_1484).getBlock());
                }
                newNetwork.update();
            }
            net.update();
        }
    }

    public static void writeNbt(class_18 world, class_8 nbt) {
        class_8 dimensionsNbt;
        class_50 dim = world.field_216;
        Optional dimIdentifierO = DimensionRegistry.INSTANCE.getIdByLegacyId(dim.field_2179);
        if (dimIdentifierO.isEmpty()) {
            NyaLib.LOGGER.error("Dimension {} not found", (Object)dim.field_2179);
            return;
        }
        Identifier dimIdentifier = (Identifier)dimIdentifierO.get();
        if (!nbt.method_1023("dimensions")) {
            nbt.method_1018("dimensions", new class_8());
        }
        if (!(dimensionsNbt = nbt.method_1033("dimensions")).method_1023(dimIdentifier.toString())) {
            dimensionsNbt.method_1018(dimIdentifier.toString(), new class_8());
        }
        class_8 dimensionNbt = dimensionsNbt.method_1033(dimIdentifier.toString());
        NETWORKS.computeIfAbsent(dim, k -> new HashMap());
        for (Map.Entry<Identifier, ArrayList<Network>> networksOfType : NetworkManager.getNetworks(dim).entrySet()) {
            Identifier type = networksOfType.getKey();
            ArrayList<Network> networks = networksOfType.getValue();
            dimensionNbt.method_1018(type.toString(), new class_8());
            class_8 networksOfTypeNbt = dimensionNbt.method_1033(type.toString());
            for (Network network : networks) {
                networksOfTypeNbt.method_1018("" + network.id, network.toNbt());
            }
        }
        NetworkManager.removeQueuedNetworks();
    }

    public static void readNbt(class_18 world, class_8 nbt) {
        class_50 dim = world.field_216;
        Optional dimIdentifierO = DimensionRegistry.INSTANCE.getIdByLegacyId(dim.field_2179);
        if (dimIdentifierO.isEmpty()) {
            NyaLib.LOGGER.error("Dimension {} not found", (Object)dim.field_2179);
            return;
        }
        Identifier dimIdentifier = (Identifier)dimIdentifierO.get();
        class_8 dimensionsNbt = nbt.method_1033("dimensions");
        class_8 dimensionNbt = dimensionsNbt.method_1033(dimIdentifier.toString());
        for (Object networksOfTypeO : dimensionNbt.method_1024()) {
            if (!(networksOfTypeO instanceof class_8)) continue;
            class_8 networksOfType = (class_8)networksOfTypeO;
            for (Object networksO : networksOfType.method_1024()) {
                if (!(networksO instanceof class_8)) continue;
                class_8 networks = (class_8)networksO;
                NetworkManager.addNetwork(dim, Network.fromNbt(networks, world, Identifier.of((String)networksOfType.method_626())));
            }
        }
    }
}

