package net.danygames2014.nyalib.fluid;

import net.minecraft.class_17;
import net.minecraft.class_629;
import net.modificationstation.stationapi.api.util.Identifier;


public final class Fluid {
    private final Identifier identifier;
    private final class_17 still;
    private final class_17 flowing;
    private int bucketSize = 1000;

    public Fluid(Identifier identifier, class_17 still, class_17 flowing) {
        this.identifier = identifier;
        this.still = still;
        this.flowing = flowing;
    }

    // Identifier
    public Identifier getIdentifier() {
        return identifier;
    }
    
    // Buckets
    public Fluid setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }
    
    public int getBucketSize() {
        return bucketSize;
    }
    
    public class_17 getBucketFluid(){
        return flowing;
    }
    
    // Blocks
    public class_17 getStillBlock(){
        return still;
    }
    
    public class_17 getFlowingBlock(){
        return flowing;
    }
    
    // Localization
    public String getTranslationKey() {
        return "fluid." + identifier.namespace + "." + identifier.path + ".name";
    }

    public String getTranslatedName() {
        return class_629.method_2049(getTranslationKey());
    }
}
