package net.danygames2014.nyalib.mixin.item;

import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.item.ItemHandler;
import net.minecraft.class_138;
import net.minecraft.class_31;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.recipe.FuelRegistry;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@SuppressWarnings({"AddedMixinMembersNamePattern", "DuplicatedCode"})
@Mixin(class_138.class)
public abstract class FurnaceBlockEntityMixin extends class_55 implements ItemHandler {
    @Shadow
    public abstract class_31 removeStack(int slot, int amount);

    @Shadow
    public abstract class_31 getStack(int slot);

    @Shadow
    public abstract void setStack(int slot, class_31 stack);

    @Shadow
    public abstract int size();

    @Shadow
    private class_31[] inventory;

    @Override
    public boolean canExtractItem(@Nullable Direction direction) {
        // Simplified Handling
        if (NyaLib.ITEM_CONFIG.simplifiedFurnaceHandling) {
            return true;
        }

        // Normal Hnadling
        if (direction == null) {
            return false;
        }

        return direction != Direction.DOWN && direction != Direction.UP;
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction direction) {
        // Simplified Handling
        if (NyaLib.ITEM_CONFIG.simplifiedFurnaceHandling) {
            return this.removeStack(slot, amount);
        }

        // Normal Handling
        if (canExtractItem(direction) && slot == 2) {
            return this.removeStack(slot, amount);
        } else {
            return null;
        }
    }

    @Override
    public boolean canInsertItem(@Nullable Direction direction) {
        // Simplified Handling
        if (NyaLib.ITEM_CONFIG.simplifiedFurnaceHandling) {
            return true;
        }

        // Normal Handling
        if (direction == null) {
            return false;
        }

        return direction == Direction.DOWN || direction == Direction.UP;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction direction) {
        if (!NyaLib.ITEM_CONFIG.simplifiedFurnaceHandling) {
            if (direction == null) {
                return stack;
            }

            // Disallow inserting into Input from Bottom
            if (slot == 0 && direction == Direction.DOWN) {
                return stack;
            }

            // Disallow inserting Fuel from Top
            if (slot == 1 && direction == Direction.UP) {
                return stack;
            }
        }

        // Only allow fuels into the fuel slot
        if (slot == 1 && FuelRegistry.getFuelTime(stack) <= 0) {
            return stack;
        }

        class_31 slotStack;

        slotStack = this.getStack(slot);

        if (slotStack == null) {
            this.setStack(slot, stack);
            return null;
        }

        if (slotStack.method_702(stack)) {
            int addedCount = Math.min(slotStack.method_694().method_459() - slotStack.field_751, stack.field_751);

            slotStack.field_751 += addedCount;

            if (addedCount >= stack.field_751) {
                return null;
            } else {
                return new class_31(stack.method_694(), stack.field_751 - addedCount, stack.method_722());
            }
        }

        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction direction) {
        class_31 insertedStack = stack.method_724();

        for (int i = 0; i < this.getItemSlots(direction); ++i) {
            insertedStack = insertItem(insertedStack, i, direction);
            if (insertedStack == null) {
                return insertedStack;
            }
        }

        return insertedStack;
    }

    @Override
    public class_31 getItemInSlot(int slot, @Nullable Direction direction) {
        return this.getStack(slot);
    }

    @Override
    public class_31[] getInventory(@Nullable Direction direction) {
        return this.inventory;
    }

    @Override
    public int getItemSlots(Direction direction) {
        return this.size();
    }
}
