/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.block;

import java.util.ArrayList;
import java.util.List;
import net.danygames2014.nyalib.block.SlabType;
import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;

public class SlabBlockTemplate
extends TemplateBlock {
    public static final EnumProperty<SlabType> SLAB_TYPE = EnumProperty.of((String)"slab_type", SlabType.class);

    public SlabBlockTemplate(Identifier identifier, class_17 baseBlock) {
        super(identifier, baseBlock.field_1900);
        this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        this.method_1590(0);
    }

    public void method_1616(class_14 blockView, int x, int y, int z) {
        if (!(blockView instanceof BlockStateView)) {
            return;
        }
        BlockStateView view = (BlockStateView)blockView;
        switch ((SlabType)((Object)view.getBlockState(x, y, z).get(SLAB_TYPE))) {
            case BOTTOM: {
                this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
                break;
            }
            case TOP: {
                this.method_1578(0.0f, 0.5f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case DOUBLE: {
                this.method_1578(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + ((class_18)blockView).getBlockState(x, y, z).get(SLAB_TYPE));
            }
        }
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{SLAB_TYPE});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        BlockState state = this.getDefaultState();
        Direction side = context.getSide();
        if (side == Direction.DOWN) {
            return (BlockState)state.with(SLAB_TYPE, (Comparable)((Object)SlabType.TOP));
        }
        return (BlockState)state.with(SLAB_TYPE, (Comparable)((Object)SlabType.BOTTOM));
    }

    public void method_1606(class_18 world, int x, int y, int z, int direction) {
        if (world.getBlockState(x, y, z).get(SLAB_TYPE) != SlabType.DOUBLE && (direction == 1 || direction == 0)) {
            int offset;
            int n = offset = direction == 0 ? 1 : -1;
            if (world.method_1776(x, y + offset, z) == this.field_1915) {
                if (direction == 0 && world.getBlockState(x, y + offset, z).get(SLAB_TYPE) == SlabType.TOP) {
                    world.method_229(x, y, z, 0);
                    world.setBlockState(x, y + offset, z, (BlockState)this.getDefaultState().with(SLAB_TYPE, (Comparable)((Object)SlabType.DOUBLE)));
                } else if (direction == 1 && world.getBlockState(x, y + offset, z).get(SLAB_TYPE) == SlabType.BOTTOM) {
                    world.method_229(x, y, z, 0);
                    world.setBlockState(x, y + offset, z, (BlockState)this.getDefaultState().with(SLAB_TYPE, (Comparable)((Object)SlabType.DOUBLE)));
                }
            }
        }
    }

    public List<class_31> getDropList(class_18 world, int x, int y, int z, BlockState state, int meta) {
        ArrayList<class_31> drops = new ArrayList<class_31>();
        if (state.get(SLAB_TYPE) == SlabType.DOUBLE) {
            drops.add(new class_31((class_17)this, 2));
            return drops;
        }
        drops.add(new class_31((class_17)this, 1));
        return drops;
    }

    public boolean method_1623() {
        return false;
    }

    public boolean method_1620() {
        return false;
    }
}

