/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.network.NetworkComponent;
import net.danygames2014.nyalib.network.NetworkComponentEntry;
import net.danygames2014.nyalib.network.NetworkEdgeComponent;
import net.danygames2014.nyalib.network.NetworkNodeComponent;
import net.danygames2014.nyalib.network.NetworkPath;
import net.danygames2014.nyalib.network.NetworkPathManager;
import net.danygames2014.nyalib.network.NetworkType;
import net.danygames2014.nyalib.network.NetworkTypeRegistry;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_187;
import net.minecraft.class_202;
import net.minecraft.class_63;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class Network {
    protected HashMap<class_63, NetworkComponentEntry> components;
    public NetworkPathManager pathManager;
    public class_18 world;
    public NetworkType type;
    protected int id;

    public Network(class_18 world, NetworkType type) {
        this.world = world;
        this.type = type;
        this.components = new HashMap();
        this.pathManager = new NetworkPathManager(this);
    }

    private Network(class_18 world) {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    private Network(NetworkType type) {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    private Network() {
        throw new IllegalArgumentException("The use of this contructor is not supported. Use the Network(World, NetworkType) constructor");
    }

    public boolean isAt(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        return this.components.containsKey(pos);
    }

    public boolean isAt(class_63 pos) {
        return this.components.containsKey(pos);
    }

    public NetworkComponentEntry getEntry(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        return this.components.get(pos);
    }

    public NetworkComponentEntry getEntry(class_63 pos) {
        return this.components.get(pos);
    }

    public NetworkPath getPath(class_63 from, class_63 to) {
        return this.pathManager.getPath(from, to);
    }

    public NetworkPath getPath(NetworkComponentEntry from, NetworkComponentEntry to) {
        return this.getPath(from.pos(), to.pos());
    }

    public boolean isPathValid(NetworkPath path) {
        return true;
    }

    public void addBlock(int x, int y, int z, class_17 block) {
        if (block instanceof NetworkComponent) {
            NetworkComponent component = (NetworkComponent)block;
            class_63 pos = new class_63(x, y, z);
            this.components.put(pos, new NetworkComponentEntry(pos, block, component, new class_8()));
            component.onAddedToNet(this.world, x, y, z, this);
        }
    }

    public boolean removeBlock(int x, int y, int z) {
        class_63 pos = new class_63(x, y, z);
        if (this.components.containsKey(pos)) {
            class_17 class_172 = this.components.get(pos).block();
            if (class_172 instanceof NetworkComponent) {
                NetworkComponent component = (NetworkComponent)class_172;
                component.onRemovedFromNet(this.world, x, y, z, this);
            }
            this.components.remove(pos);
            return true;
        }
        return false;
    }

    public void tick() {
    }

    public void postEntityTick() {
    }

    public void worldTick() {
    }

    public void update() {
        for (Map.Entry<class_63, NetworkComponentEntry> block : this.components.entrySet()) {
            class_63 pos = block.getKey();
            class_17 class_172 = block.getValue().block();
            if (!(class_172 instanceof NetworkComponent)) continue;
            NetworkComponent component = (NetworkComponent)class_172;
            component.update(this.world, pos.field_1482, pos.field_1483, pos.field_1484, this);
        }
    }

    public ArrayList<class_63> walk(class_63 start) {
        ArrayList<class_63> open = new ArrayList<class_63>();
        ArrayList<class_63> closed = new ArrayList<class_63>();
        open.add(start);
        while (!open.isEmpty()) {
            class_63 pos = (class_63)open.get(0);
            for (Direction dir : Direction.values()) {
                class_63 side = new class_63(pos.field_1482 + dir.getOffsetX(), pos.field_1483 + dir.getOffsetY(), pos.field_1484 + dir.getOffsetZ());
                if (!this.components.containsKey(side) || closed.contains(side) || !this.getEntry(side).component().canConnectTo(this.world, pos.field_1482, pos.field_1483, pos.field_1484, this, dir) || !this.getEntry(pos).component().canConnectTo(this.world, side.field_1482, side.field_1483, side.field_1484, this, dir)) continue;
                NetworkComponent component = this.getEntry(side).component();
                if (component instanceof NetworkNodeComponent) {
                    open.add(side);
                    continue;
                }
                if (!(component instanceof NetworkEdgeComponent)) continue;
                closed.add(side);
            }
            closed.add(pos);
            open.remove(pos);
        }
        return closed;
    }

    public void writeNbt(class_8 tag) {
    }

    public void readNbt(class_8 tag) {
    }

    public class_8 toNbt() {
        class_8 tag = new class_8();
        class_202 blocksNbt = new class_202();
        tag.method_1015("id", this.id);
        tag.method_1017("blocks", (class_187)blocksNbt);
        for (Map.Entry<class_63, NetworkComponentEntry> entry : this.components.entrySet()) {
            class_8 blockNbt = new class_8();
            class_63 pos = entry.getKey();
            blockNbt.method_1015("x", pos.field_1482);
            blockNbt.method_1015("y", pos.field_1483);
            blockNbt.method_1015("z", pos.field_1484);
            class_17 class_172 = entry.getValue().block();
            if (class_172 instanceof NetworkComponent) {
                NetworkComponent component = (NetworkComponent)class_172;
                component.writeNbt(this.world, pos.field_1482, pos.field_1483, pos.field_1484, this, blockNbt);
            }
            blockNbt.method_1018("entryData", entry.getValue().data());
            blocksNbt.method_1397((class_187)blockNbt);
        }
        this.writeNbt(tag);
        return tag;
    }

    public static Network fromNbt(class_8 tag, class_18 world, Identifier networkTypeIdentifier) {
        Network network;
        NetworkType networkType = NetworkTypeRegistry.get(networkTypeIdentifier);
        if (networkType == null) {
            NyaLib.LOGGER.error("Network of type {} not found in registry. Has the modlist been changed? Skipping the loading of this network.", (Object)networkTypeIdentifier);
            return null;
        }
        try {
            network = networkType.getNetworkClass().getDeclaredConstructor(class_18.class, NetworkType.class).newInstance(world, networkType);
        }
        catch (Exception e) {
            NyaLib.LOGGER.error("Error when creating a network of type {}", (Object)networkType.getIdentifier(), (Object)e);
            return null;
        }
        network.components = new HashMap();
        network.id = tag.method_1027("id");
        class_202 blocksNbt = tag.method_1034("blocks");
        for (int i = 0; i < blocksNbt.method_1398(); ++i) {
            class_8 blockNbt = (class_8)blocksNbt.method_1396(i);
            class_63 pos = new class_63(blockNbt.method_1027("x"), blockNbt.method_1027("y"), blockNbt.method_1027("z"));
            class_17 block = world.getBlockState(pos.field_1482, pos.field_1483, pos.field_1484).getBlock();
            if (!(block instanceof NetworkComponent)) continue;
            NetworkComponent component = (NetworkComponent)block;
            component.readNbt(world, pos.field_1482, pos.field_1483, pos.field_1484, network, blockNbt);
            network.components.put(pos, new NetworkComponentEntry(pos, block, component, blockNbt.method_1033("entryData")));
            component.onAddedToNet(world, pos.field_1482, pos.field_1483, pos.field_1484, network);
        }
        network.readNbt(tag);
        return network;
    }

    public int getId() {
        return this.id;
    }
}

