/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.util.HashMap;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkComponent;
import net.danygames2014.nyalib.network.NetworkPath;
import net.danygames2014.nyalib.util.AStar;
import net.minecraft.class_17;
import net.minecraft.class_63;
import net.modificationstation.stationapi.api.util.math.Direction;

public class NetworkPathManager {
    Network network;
    HashMap<class_63, HashMap<class_63, NetworkPath>> pathCache;

    private NetworkPathManager() {
    }

    public NetworkPathManager(Network network) {
        this.network = network;
        this.pathCache = new HashMap();
    }

    public NetworkPath getPath(class_63 from, class_63 to) {
        if (!this.pathCache.containsKey(from)) {
            this.pathCache.put(from, new HashMap());
        }
        if (!this.pathCache.get(from).containsKey(to) || !this.validatePath(this.pathCache.get(from).get(to))) {
            this.pathCache.get(from).put(to, this.computePath(from, to));
        }
        return this.pathCache.get(from).get(to);
    }

    public boolean validatePath(NetworkPath path) {
        for (class_63 point : path.path) {
            if (this.network.components.containsKey(point)) continue;
            return false;
        }
        return this.network.isPathValid(path);
    }

    /*
     * WARNING - void declaration
     */
    public NetworkPath computePath(class_63 from, class_63 to) {
        void var9_14;
        AStar aStar = new AStar(from, to, this.network.components.keySet().toArray(new class_63[0]));
        class_63[] path = aStar.calculate();
        int cost = 0;
        for (class_63 class_632 : path) {
            class_17 class_172 = this.network.world.getBlockState(class_632.field_1482, class_632.field_1483, class_632.field_1484).getBlock();
            if (!(class_172 instanceof NetworkComponent)) continue;
            NetworkComponent component = (NetworkComponent)class_172;
            cost += component.getPathingCost(this.network.world, class_632.field_1482, class_632.field_1483, class_632.field_1484, this.network);
        }
        class_63 end = path[path.length - 1];
        class_63 beforeEnd = path[path.length - 2];
        Direction endFace = null;
        for (Direction dir : Direction.values()) {
            if (beforeEnd.field_1482 + dir.getOffsetX() != end.field_1482 || beforeEnd.field_1483 + dir.getOffsetY() != end.field_1483 || beforeEnd.field_1484 + dir.getOffsetZ() != end.field_1484) continue;
            endFace = dir.getOpposite();
        }
        Object var9_13 = null;
        if (path.length >= 2) {
            class_63 start = path[0];
            class_63 afterStart = path[1];
            for (Direction dir : Direction.values()) {
                if (start.field_1482 + dir.getOffsetX() != afterStart.field_1482 || start.field_1483 + dir.getOffsetY() != afterStart.field_1483 || start.field_1484 + dir.getOffsetZ() != afterStart.field_1484) continue;
                Direction direction = dir;
            }
        }
        return new NetworkPath(from, (Direction)var9_14, to, endFace, path, cost);
    }
}

