package net.danygames2014.nyalib.block;

import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_229;
import net.minecraft.class_25;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;

public class FenceBlockTemplate extends TemplateBlock {
    public static final BooleanProperty NORTH = BooleanProperty.of("north"); // X--
    public static final BooleanProperty SOUTH = BooleanProperty.of("south"); // X++
    public static final BooleanProperty EAST = BooleanProperty.of("east"); // Z--
    public static final BooleanProperty WEST = BooleanProperty.of("west"); // Z++

    public FenceBlockTemplate(Identifier identifier, class_17 baseBlock) {
        this(identifier, baseBlock, null);
    }
    
    public FenceBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        super(identifier, baseBlock.field_1900);
        this.method_1590(0);
        if (texture != null) {
            TemplateBlockRegistry.registerFence(identifier, texture);
        }
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(NORTH);
        builder.add(SOUTH);
        builder.add(EAST);
        builder.add(WEST);
    }

    public class_25 generateBox(class_18 world, int x, int y, int z, boolean collider) {
        BlockState state = world.getBlockState(x, y, z);

        if (!(state.getBlock() instanceof FenceBlockTemplate)) {
            return null;
        }

        class_25 box = class_25.method_87(state.get(NORTH) ? 0 : 0.375F, 0F, state.get(EAST) ? 0F : 0.375F, state.get(SOUTH) ? 1F : 0.625F, 1F, state.get(WEST) ? 1.F : 0.625F);

        box.field_129 += x;
        box.field_130 += y;
        box.field_131 += z;
        box.field_132 += x;
        box.field_133 += y;
        box.field_134 += z;

        if (collider) {
            box.field_133 += 0.5F;
        }

        return box;
    }

    @Override
    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return generateBox(world, x, y, z, true);
    }

    @Override
    public class_25 method_1622(class_18 world, int x, int y, int z) {
        return generateBox(world, x, y, z, false);
    }

    @Override
    public void method_1609(class_18 world, int x, int y, int z, int id) {
        this.updateConnections(world, x, y, z);
        super.method_1609(world, x, y, z, id);
    }

    @Override
    public void method_1611(class_18 world, int x, int y, int z) {
        this.updateConnections(world, x, y, z);
        super.method_1611(world, x, y, z);
    }

    public void updateConnections(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);

        state = state.with(NORTH, canConnectTo(world.getBlockState(x - 1, y, z)));
        state = state.with(SOUTH, canConnectTo(world.getBlockState(x + 1, y, z)));
        state = state.with(EAST, canConnectTo(world.getBlockState(x, y, z - 1)));
        state = state.with(WEST, canConnectTo(world.getBlockState(x, y, z + 1)));

        world.setBlockStateWithNotify(x, y, z, state);
    }

    public boolean canConnectTo(BlockState state) {
        if (state.isAir()) {
            return false;
        }
        
        class_17 block = state.getBlock();
        if (block instanceof WallBlockTemplate || block instanceof FenceBlockTemplate || block instanceof FenceGateBlockTemplate || block instanceof class_229) {
            return true;
        }

        if (state.getMaterial().method_897() && state.getBlock().method_1623()) {
            return true;
        }

        return false;
    }

    @Override
    public boolean method_1623() {
        return false;
    }

    @Override
    public boolean method_1620() {
        return false;
    }
}
