package net.danygames2014.nyalib.block;

import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_229;
import net.minecraft.class_25;
import net.minecraft.class_494;
import net.minecraft.class_619;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.StringIdentifiable;
import net.modificationstation.stationapi.api.util.math.Direction;

public class WallBlockTemplate extends TemplateBlock {
    public static final EnumProperty<WallType> EAST = EnumProperty.of("east", WallType.class);
    public static final EnumProperty<WallType> WEST = EnumProperty.of("west", WallType.class);
    public static final EnumProperty<WallType> NORTH = EnumProperty.of("north", WallType.class);
    public static final EnumProperty<WallType> SOUTH = EnumProperty.of("south", WallType.class);
    public static final BooleanProperty UP = BooleanProperty.of("up");

    public WallBlockTemplate(Identifier identifier, class_17 baseBlock, class_15 material, Identifier texture) {
        super(identifier, material);
        if (texture != null) {
            TemplateBlockRegistry.registerWall(identifier, texture);
        }
    }

    public WallBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        this(identifier, baseBlock, baseBlock.field_1900, texture);
    }

    public WallBlockTemplate(Identifier identifier, class_17 baseBlock) {
        this(identifier, baseBlock, null);
    }

    // Block Properties
    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(EAST, WEST, NORTH, SOUTH, UP);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        return super.getPlacementState(context)
                .with(EAST, WallType.NONE)
                .with(WEST, WallType.NONE)
                .with(NORTH, WallType.NONE)
                .with(SOUTH, WallType.NONE)
                .with(UP, true);
    }

    @Override
    public void method_1611(class_18 world, int x, int y, int z) {
        updateConnections(world, x, y, z);
        super.method_1611(world, x, y, z);
    }

    @Override
    public void method_1609(class_18 world, int x, int y, int z, int id) {
        updateConnections(world, x, y, z);
        super.method_1609(world, x, y, z, id);
    }

    public void updateConnections(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);

        state = getWallState(world, x, y, z, state, Direction.EAST, EAST);
        state = getWallState(world, x, y, z, state, Direction.WEST, WEST);
        state = getWallState(world, x, y, z, state, Direction.NORTH, NORTH);
        state = getWallState(world, x, y, z, state, Direction.SOUTH, SOUTH);

        state = state.with(UP, true);

        if (state.get(EAST) == WallType.NONE && state.get(WEST) == WallType.NONE && state.get(NORTH) != WallType.NONE && state.get(SOUTH) != WallType.NONE) {
            state = state.with(UP, false);
        } else if (state.get(NORTH) == WallType.NONE && state.get(SOUTH) == WallType.NONE && state.get(EAST) != WallType.NONE && state.get(WEST) != WallType.NONE) {
            state = state.with(UP, false);
        }

        // Check if we create post anyway
        if (canConnectPost(world.getBlockState(x, y + 1, z))) {
            state = state.with(UP, true);
        }

        world.setBlockStateWithNotify(x, y, z, state);
    }

    public boolean canConnectPost(BlockState state) {
        if (state.isOf(this)) {
            return state.get(UP);
        }

        class_17 block = state.getBlock();
        if (block instanceof class_494 || block instanceof class_619 || block instanceof class_229 || block instanceof FenceBlockTemplate) {
            return true;
        }

        return false;
    }

    public boolean canConnectTo(BlockState state) {
        if (state.isAir()) {
            return false;
        }

        class_17 block = state.getBlock();
        if (block instanceof WallBlockTemplate || block instanceof FenceBlockTemplate || block instanceof FenceGateBlockTemplate || block instanceof class_229 || block instanceof PaneBlockTemplate) {
            return true;
        }

        if (state.getMaterial().method_897() && state.getBlock().method_1623()) {
            return true;
        }

        return false;
    }

    private BlockState getWallState(class_18 world, int x, int y, int z, BlockState state, Direction side, EnumProperty<WallType> property) {
        if (canConnectTo(world.getBlockState(x + side.getOffsetX(), y, z + side.getOffsetZ()))) {
            state = state.with(property, WallType.LOW);

            if (canConnectTo(world.getBlockState(x, y + 1, z)) && canConnectTo(world.getBlockState(x + side.getOffsetX(), y + 1, z + side.getOffsetZ()))) {
                state = state.with(property, WallType.TALL);
            }
        } else {
            state = state.with(property, WallType.NONE);
        }

        return state;
    }

    // Collision and Bounding Box
    public class_25 generateBox(class_18 world, int x, int y, int z, boolean collider) {
        BlockState state = world.getBlockState(x, y, z);

        if (!(state.getBlock() instanceof WallBlockTemplate)) {
            return null;
        }

        class_25 box = class_25.method_87(state.get(NORTH) != WallType.NONE ? 0 : 0.25F, 0F, state.get(EAST) != WallType.NONE ? 0F : 0.25F, state.get(SOUTH) != WallType.NONE ? 1F : 0.75F, 1F, state.get(WEST) != WallType.NONE ? 1F : 0.75F);

        box.field_129 += x;
        box.field_130 += y;
        box.field_131 += z;
        box.field_132 += x;
        box.field_133 += y;
        box.field_134 += z;

        if (collider) {
            box.field_133 += 0.5F;
        }

        return box;
    }

    @Override
    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return generateBox(world, x, y, z, true);
    }

    @Override
    public class_25 method_1622(class_18 world, int x, int y, int z) {
        return generateBox(world, x, y, z, false);
    }

    // Rendering
    @Override
    public boolean method_1620() {
        return false;
    }

    @Override
    public boolean method_1623() {
        return false;
    }

    public enum WallType implements StringIdentifiable {
        NONE("none"),
        LOW("low"),
        TALL("tall");

        public final String id;

        WallType(String id) {
            this.id = id;
        }

        @Override
        public String asString() {
            return id;
        }
    }
}
