package net.danygames2014.nyalib.capability.block.itemhandler;

import net.danygames2014.nyalib.item.ItemHandler;
import net.minecraft.class_124;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

class ItemHandlerInterfaceBlockCapability extends ItemHandlerBlockCapability {
    private final ItemHandler itemHandler;
    
    public ItemHandlerInterfaceBlockCapability(ItemHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public boolean canConnectItem(Direction direction) {
        return itemHandler.canConnectItem(direction);
    }

    @Override
    public boolean canExtractItem(@Nullable Direction direction) {
        return itemHandler.canExtractItem(direction);
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction direction) {
        return itemHandler.extractItem(slot, amount, direction);
    }

    @Override
    public class_31 extractItem(@Nullable Direction direction) {
        return itemHandler.extractItem(direction);
    }

    @Override
    public class_31 extractItem(class_124 item, int amount, @Nullable Direction direction) {
        return itemHandler.extractItem(item, amount, direction);
    }

    @Override
    public class_31 extractItem(int amount, @Nullable Direction direction) {
        return itemHandler.extractItem(amount, direction);
    }

    @Override
    public boolean canInsertItem(@Nullable Direction direction) {
        return itemHandler.canInsertItem(direction);
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction direction) {
        return itemHandler.insertItem(stack, slot, direction);
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction direction) {
        return itemHandler.insertItem(stack, direction);
    }

    @Override
    public class_31 getItem(int slot, @Nullable Direction direction) {
        return itemHandler.getItem(slot, direction);
    }

    @Override
    public boolean setItem(class_31 stack, int slot, @Nullable Direction direction) {
        return itemHandler.setItem(stack, slot, direction);
    }

    @Override
    public int getItemSlots(@Nullable Direction direction) {
        return itemHandler.getItemSlots(direction);
    }

    @Override
    public class_31[] getInventory(@Nullable Direction direction) {
        return itemHandler.getInventory(direction);
    }
}
