package net.danygames2014.nyalib.item;

import net.minecraft.class_124;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

/**
 * An Item Handler interface to be implemented on {@link class_124}
 * The first parameter is always the ItemStack of the Item on which this code is called on
 */
@SuppressWarnings("unused")
public interface ItemHandlerItem {
    /**
     * Check if the handler supports extracting items, if this returns false there
     * should be no point in trying to use {@link #extractItem(class_31, int, int)}
     *
     * @param thiz The stack, on which this action is called on
     * @return <code>true</code> if the device supports item extraction
     */
    boolean canExtractItem(class_31 thiz);

    /**
     * Extract an item in the given slot
     *
     * @param thiz   The stack, on which this action is called on
     * @param slot   The slot to extract from
     * @param amount The amount to extract (can be larger than the maximum stack size)
     * @return The ItemStack extracted, null if nothing is extracted
     */
    class_31 extractItem(class_31 thiz, int slot, int amount);

    /**
     * Extract any item
     *
     * @param thiz   The stack, on which this action is called on
     * @return The extracted ItemStack
     */
    default class_31 extractItem(class_31 thiz) {
        return extractItem(thiz, Integer.MAX_VALUE);
    }
    
    /**
     * Extract a specified amount of any item
     *
     * @param thiz The stack, on which this action is called on
     * @return The extracted ItemStack
     */
    default class_31 extractItem(class_31 thiz, int amount) {
        for (int i = 0; i < getItemSlots(thiz); i++) {
            if (getItem(thiz, i) != null) {
                return extractItem(thiz, i, amount);
            }
        }
        return null;
    }


    /**
     * Extract the given item in any slot from the handler
     *
     * @param thiz   The stack, on which this action is called on
     * @param item   The Item to extract
     * @param amount The amount to extract (can be larger than the maximum stack size)
     * @return The ItemStack extracted, null if nothing is extracted
     */
    default class_31 extractItem(class_31 thiz, class_124 item, int amount) {
        class_31 currentStack = null;
        int remaining = amount;

        for (int i = 0; i < getItemSlots(thiz); i++) {
            if (remaining <= 0) {
                break;
            }

            if (currentStack != null) {
                if (this.getItem(thiz, i).method_702(currentStack)) {
                    class_31 extractedStack = extractItem(thiz, i, remaining);
                    remaining -= extractedStack.field_751;
                    currentStack.field_751 += extractedStack.field_751;
                }
            } else {
                if (getItem(thiz, i).isOf(item)) {
                    class_31 extractedStack = extractItem(thiz, i, remaining);
                    remaining -= extractedStack.field_751;
                    currentStack = extractedStack;
                }
            }
        }

        return currentStack;
    }

    /**
     * Check if the handler supports inserting items, if this returns false there
     * should be no point in trying to use {@link #insertItem(class_31, class_31)} or {@link #insertItem(class_31, class_31, int)}
     *
     * @param thiz The stack, on which this action is called on
     * @return <code>true</code> if the device supports item insertion
     */
    boolean canInsertItem(class_31 thiz);

    /**
     * Insert item into the given slot and return the remainder
     *
     * @param thiz  The stack, on which this action is called on
     * @param stack The {@link class_31} to insert
     * @param slot  Slot to insert into
     * @return The remainder of the ItemStack (null if it was inserted entirely), this should be a new ItemStack, however it can be the same if it was not modified
     */
    class_31 insertItem(class_31 thiz, class_31 stack, int slot);

    /**
     * Insert item into any slot and return the remainder
     *
     * @param thiz  The stack, on which this action is called on
     * @param stack The {@link class_31} to insert
     * @return The remainder of the ItemStack (null if it was inserted entirely), this should be a new ItemStack, however it can be the same if it was not modified
     */
    class_31 insertItem(class_31 thiz, class_31 stack);

    /**
     * Get the {@link class_31} in the given slot, If there is no {@link class_31}, then return null
     * <p>
     *
     * @param thiz The stack, on which this action is called on
     * @param slot The slot to get the {@link class_31} from
     * @return The {@link class_31} in the slot
     */
    class_31 getItem(class_31 thiz, int slot);

    /**
     * Directly sets the given slot to the given ItemStack
     *
     * @param thiz  The stack, on which this action is called on
     * @param stack The {@link class_31} to set the slot to
     * @param slot  The slot to put the stack into
     * @return Whether the action was successfull
     */
    boolean setItem(class_31 thiz, class_31 stack, int slot);

    /**
     * Get the size of the handler inventory
     *
     * @param thiz The stack, on which this action is called on
     * @return The number of slots this handler has
     */
    int getItemSlots(class_31 thiz);

    /**
     * Get the entire inventory of the handler
     *
     * @param thiz The stack, on which this action is called on
     * @return An array of all the ItemStacks
     */
    class_31[] getInventory(class_31 thiz);
}
