package net.danygames2014.nyalib.mixin.block;

import net.danygames2014.nyalib.block.DropInventoryOnBreak;
import net.minecraft.class_134;
import net.minecraft.class_142;
import net.minecraft.class_18;
import net.minecraft.class_31;
import net.minecraft.class_395;
import net.minecraft.class_55;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Random;

@Mixin(class_395.class)
public class BlockWithEntityMixin {
    @Inject(method = "onBreak", at = @At(value = "HEAD"))
    public void dropIt(class_18 world, int x, int y, int z, CallbackInfo ci) {
        class_55 blockEntity = world.method_1777(x, y, z);

        if (this instanceof DropInventoryOnBreak dropInventoryOnBreak && blockEntity instanceof class_134 inventory) {
            if (!dropInventoryOnBreak.shouldDropInventory(world, x, y, z)) {
                return;
            }

            Random random = new Random();

            for (int i = 0; i < inventory.method_948(); ++i) {
                class_31 stack = inventory.method_954(i);
                if (stack != null) {
                    float xPos = random.nextFloat() * 0.8F + 0.1F;
                    float yPos = random.nextFloat() * 0.8F + 0.1F;
                    float zPos = random.nextFloat() * 0.8F + 0.1F;

                    class_142 itemEntity = new class_142(world, (float) x + xPos, (float) y + yPos, (float) z + zPos, stack.method_724());
                    itemEntity.field_1603 = (float) random.nextGaussian() * 0.05F;
                    itemEntity.field_1604 = (float) random.nextGaussian() * 0.05F + 0.2F;
                    itemEntity.field_1605 = (float) random.nextGaussian() * 0.05F;
                    world.method_210(itemEntity);
                }
            }
        }
    }
}
