package net.danygames2014.nyalib.mixin.item;

import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.item.ItemHandler;
import net.minecraft.class_138;
import net.minecraft.class_31;
import net.minecraft.class_55;
import net.modificationstation.stationapi.api.recipe.FuelRegistry;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@SuppressWarnings({"AddedMixinMembersNamePattern", "DuplicatedCode"})
@Mixin(class_138.class)
public abstract class FurnaceBlockEntityMixin extends class_55 implements ItemHandler {
    @Shadow
    public abstract class_31 removeStack(int slot, int amount);

    @Shadow
    public abstract class_31 getStack(int slot);

    @Shadow
    public abstract void setStack(int slot, class_31 stack);

    @Shadow
    public abstract int size();

    @Shadow
    private class_31[] inventory;

    // Slots
    // 0 - Input
    // 1 - Fuel
    // 2 - Output

    // Sides
    // Top - Input Insert / Input Extract
    // Sides - Fuel Insert / Output Extract
    // Bottom - Fuel Insert / Output Extract

    @Override
    public boolean canExtractItem(@Nullable Direction direction) {
        return true;
    }

    @Override
    public class_31 extractItem(int amount, @Nullable Direction direction) {
        if (!canExtractItem(direction)) {
            return null;
        }
        
        if (!NyaLib.ITEM_CONFIG.simplifiedFurnaceHandling && direction != null) {
            switch (direction) {
                // Extract from UP -> Input Slot
                case UP -> {
                    if (getItem(0, direction) != null) {
                        return extractItem(0, amount, direction);
                    }
                }

                // Extract from any other side -> Output Slot
                case DOWN, NORTH, SOUTH, EAST, WEST -> {
                    if (getItem(2, direction) != null) {
                        return extractItem(2, amount, direction);
                    }
                }
            }
        }

        // If direction is null, keep super behavior
        return ItemHandler.super.extractItem(amount, direction);
    }

    @Override
    public class_31 extractItem(int slot, int amount, @Nullable Direction direction) {
        if (slot >= 0 && slot < inventory.length) {
            return this.removeStack(slot, amount);
        }

        return null;
    }

    @Override
    public boolean canInsertItem(@Nullable Direction direction) {
        return true;
    }

    @Override
    public class_31 insertItem(class_31 stack, int slot, @Nullable Direction direction) {
        // Only allow fuels into the fuel slot
        if (slot == 1 && FuelRegistry.getFuelTime(stack) <= 0) {
            return stack;
        }

        class_31 slotStack;

        slotStack = this.getStack(slot);

        if (slotStack == null) {
            this.setStack(slot, stack);
            return null;
        }

        if (slotStack.method_702(stack)) {
            int addedCount = Math.min(slotStack.method_694().method_459() - slotStack.field_751, stack.field_751);

            slotStack.field_751 += addedCount;

            if (addedCount >= stack.field_751) {
                return null;
            } else {
                return new class_31(stack.method_694(), stack.field_751 - addedCount, stack.method_722());
            }
        }

        return stack;
    }

    @Override
    public class_31 insertItem(class_31 stack, @Nullable Direction direction) {
        class_31 insertedStack = stack.method_724();

        if (!NyaLib.ITEM_CONFIG.simplifiedFurnaceHandling && direction != null) {
            switch (direction) {
                case UP -> {
                    // Insert into input
                    insertedStack = insertItem(insertedStack, 0, direction);
                }
                
                case NORTH, SOUTH, EAST, WEST -> {
                    if (FuelRegistry.getFuelTime(insertedStack) >= 0) {
                        // If the item has a fuel value, insert into fuel slot
                        insertedStack = insertItem(insertedStack, 1, direction);
                    } else {
                        // If the item does not have fuel value, insert into input
                        insertedStack = insertItem(insertedStack, 0, direction);
                    }
                }
                
                case DOWN -> {
                    // Insert into fuel
                    insertedStack = insertItem(insertedStack, 1, direction);
                }
            }
        } else {
            // If direction is not specified, use default behavior
            for (int i = 0; i < this.getItemSlots(direction); ++i) {
                insertedStack = insertItem(insertedStack, i, direction);
                if (insertedStack == null) {
                    return insertedStack;
                }
            }
        }

        return insertedStack;
    }

    @Override
    public class_31 getItem(int slot, @Nullable Direction direction) {
        return this.getStack(slot);
    }

    @Override
    public class_31[] getInventory(@Nullable Direction direction) {
        return this.inventory;
    }

    @Override
    public int getItemSlots(Direction direction) {
        return this.size();
    }

    @Override
    public boolean canConnectItem(Direction direction) {
        return true;
    }
}
