/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.util.AStarNode;
import net.minecraft.class_63;
import net.modificationstation.stationapi.api.util.math.Direction;

public class AStar {
    class_63 start;
    class_63 end;
    HashMap<class_63, AStarNode> open = new HashMap();
    HashMap<class_63, AStarNode> closed = new HashMap();
    HashMap<class_63, AStarNode> validNodes = new HashMap();

    public AStar(class_63 start, class_63 end, class_63[] avalibleNodes) {
        this.start = start;
        this.end = end;
        for (class_63 node : avalibleNodes) {
            this.validNodes.put(node, new AStarNode(node, null));
        }
        this.open.put(start, new AStarNode(start, null));
    }

    public class_63[] calculate() {
        AStarNode endNode = null;
        while (endNode == null) {
            AStarNode current = this.getLowestFCost();
            if (current == null) {
                NyaLib.LOGGER.debug("Current node is null. No path found.");
                return null;
            }
            this.open.remove(current.position);
            this.closed.put(current.position, current);
            if (current.position.equals((Object)this.end)) {
                endNode = current;
            }
            for (Direction direction : Direction.values()) {
                class_63 neighbor = new class_63(current.position.field_1482 + direction.getOffsetX(), current.position.field_1483 + direction.getOffsetY(), current.position.field_1484 + direction.getOffsetZ());
                if (!this.validNodes.containsKey(neighbor) || this.closed.containsKey(neighbor)) continue;
                AStarNode neighborNode = this.validNodes.get(neighbor);
                double neighborCost = neighborNode.fCost;
                double newCost = neighborNode.calculateCost(this.start, this.end);
                if (!(newCost < neighborCost) && this.open.containsKey(neighbor)) continue;
                neighborNode.fCost = newCost;
                neighborNode.parent = current;
                if (this.open.containsKey(neighbor)) continue;
                this.open.put(neighbor, neighborNode);
            }
        }
        AStarNode traversedNode = endNode;
        ArrayList<class_63> path = new ArrayList<class_63>();
        while (traversedNode != null) {
            path.add(traversedNode.position);
            traversedNode = traversedNode.parent;
        }
        Collections.reverse(path);
        return path.toArray(new class_63[0]);
    }

    AStarNode getLowestFCost() {
        double lowestCost = Double.MAX_VALUE;
        AStarNode bestNode = null;
        if (this.open.isEmpty()) {
            NyaLib.LOGGER.debug("Lowest F cost requested for empty path.");
            return null;
        }
        for (Map.Entry<class_63, AStarNode> nodeEntry : this.open.entrySet()) {
            AStarNode node = nodeEntry.getValue();
            double cost = node.calculateCost(this.start, this.end);
            if (!(cost < lowestCost)) continue;
            lowestCost = node.fCost = cost;
            bestNode = node;
        }
        return bestNode;
    }
}

