/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.particle;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.danygames2014.nyalib.NyaLib;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_528;
import net.minecraft.class_77;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class ParticlePacket
extends class_169
implements ManagedPacket<ParticlePacket> {
    public static final PacketType<ParticlePacket> TYPE = PacketType.builder((boolean)true, (boolean)false, ParticlePacket::new).build();
    double x;
    double y;
    double z;
    double velocityX;
    double velocityY;
    double velocityZ;
    String particle;
    Identifier item;

    public ParticlePacket() {
    }

    public ParticlePacket(class_124 item, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
        this.particle = "item";
        this.item = ItemRegistry.INSTANCE.getId((Object)item);
    }

    public ParticlePacket(String particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
        this.particle = particle;
        this.item = Identifier.of((String)"");
    }

    public void method_806(DataInputStream stream) {
        try {
            this.x = stream.readDouble();
            this.y = stream.readDouble();
            this.z = stream.readDouble();
            this.velocityX = stream.readDouble();
            this.velocityY = stream.readDouble();
            this.velocityZ = stream.readDouble();
            this.particle = stream.readUTF();
            this.item = Identifier.of((String)stream.readUTF());
        }
        catch (IOException e) {
            NyaLib.LOGGER.warn("Error reading particle packet", (Throwable)e);
        }
    }

    public void method_807(DataOutputStream stream) {
        try {
            stream.writeDouble(this.x);
            stream.writeDouble(this.y);
            stream.writeDouble(this.z);
            stream.writeDouble(this.velocityX);
            stream.writeDouble(this.velocityY);
            stream.writeDouble(this.velocityZ);
            stream.writeUTF(this.particle);
            stream.writeUTF(this.item.toString());
        }
        catch (IOException e) {
            NyaLib.LOGGER.warn("Error writing particle packet", (Throwable)e);
        }
    }

    public void method_808(class_240 networkHandler) {
        if (FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER)) {
            return;
        }
        this.handleClient();
    }

    @Environment(value=EnvType.CLIENT)
    public void handleClient() {
        if (this.particle.equals("item")) {
            class_124 particleItem = (class_124)ItemRegistry.INSTANCE.get(this.item);
            if (Minecraft.field_2791 != null && Minecraft.field_2791.field_2808 != null && particleItem != null) {
                Minecraft.field_2791.field_2808.method_325((class_77)new class_528(Minecraft.field_2791.field_2804, this.x, this.y, this.z, particleItem));
            }
        } else {
            Minecraft.field_2791.field_2804.method_178(this.particle, this.x, this.y, this.z, this.velocityX, this.velocityY, this.velocityZ);
        }
    }

    public int method_798() {
        return 48 + this.particle.length() + this.item.toString().length();
    }

    @NotNull
    public PacketType<ParticlePacket> getType() {
        return TYPE;
    }
}

