package net.danygames2014.nyalib.particle;

import net.danygames2014.nyalib.NyaLib;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_169;
import net.minecraft.class_240;
import net.minecraft.class_528;
import net.minecraft.client.Minecraft;
import net.modificationstation.stationapi.api.network.packet.ManagedPacket;
import net.modificationstation.stationapi.api.network.packet.PacketType;
import net.modificationstation.stationapi.api.registry.ItemRegistry;
import net.modificationstation.stationapi.api.util.Identifier;
import org.jetbrains.annotations.NotNull;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ParticlePacket extends class_169 implements ManagedPacket<ParticlePacket> {
    public static final PacketType<ParticlePacket> TYPE = PacketType.builder(true, false, ParticlePacket::new).build();

    double x;
    double y;
    double z;
    double velocityX;
    double velocityY;
    double velocityZ;
    String particle;
    Identifier item;

    public ParticlePacket() {
    }

    public ParticlePacket(class_124 item, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
        this.particle = "item";
        this.item = ItemRegistry.INSTANCE.getId(item);
    }

    public ParticlePacket(String particle, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
        this.particle = particle;
        this.item = Identifier.of("");
    }

    @Override
    public void method_806(DataInputStream stream) {
        try {
            x = stream.readDouble();
            y = stream.readDouble();
            z = stream.readDouble();
            velocityX = stream.readDouble();
            velocityY = stream.readDouble();
            velocityZ = stream.readDouble();
            particle = stream.readUTF();
            item = Identifier.of(stream.readUTF());
        } catch (IOException e) {
            NyaLib.LOGGER.warn("Error reading particle packet", e);
        }
    }

    @Override
    public void method_807(DataOutputStream stream) {
        try {
            stream.writeDouble(x);
            stream.writeDouble(y);
            stream.writeDouble(z);
            stream.writeDouble(velocityX);
            stream.writeDouble(velocityY);
            stream.writeDouble(velocityZ);
            stream.writeUTF(particle);
            stream.writeUTF(item.toString());
        } catch (IOException e) {
            NyaLib.LOGGER.warn("Error writing particle packet", e);
        }
    }

    @Override
    public void method_808(class_240 networkHandler) {
        if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.SERVER)) {
            return;
        }

        handleClient();
    }

    @Environment(EnvType.CLIENT)
    public void handleClient() {
        if (particle.equals("item")) {
            class_124 particleItem = ItemRegistry.INSTANCE.get(item);

            if (Minecraft.field_2791 != null && Minecraft.field_2791.field_2808 != null && particleItem != null) {
                Minecraft.field_2791.field_2808.method_325(new class_528(Minecraft.field_2791.field_2804, x, y, z, particleItem));
            }
        } else {
            Minecraft.field_2791.field_2804.method_178(particle, x, y, z, velocityX, velocityY, velocityZ);
        }
    }

    @Override
    public int method_798() {
        return 48 + particle.length() + item.toString().length();
    }

    @Override
    public @NotNull PacketType<ParticlePacket> getType() {
        return TYPE;
    }
}
