package net.danygames2014.nyalib.network;

import it.unimi.dsi.fastutil.objects.ObjectSet;
import net.danygames2014.nyalib.util.AStar;
import net.minecraft.class_63;
import net.modificationstation.stationapi.api.util.math.Direction;

import java.util.HashMap;
import java.util.Map;

public class NetworkPathManager {
    Network network;
    HashMap<class_63, HashMap<class_63, NetworkPath>> pathCache;

    private NetworkPathManager() {
    }

    public NetworkPathManager(Network network) {
        this.network = network;
        pathCache = new HashMap<>();
    }

    public void clearCache() {
        pathCache.clear();
    }
    
    public NetworkPath getPath(class_63 from, class_63 to) {
        // If there isnt a hashmap to the source component, create it
        if (!pathCache.containsKey(from)) {
            pathCache.put(from, new HashMap<>());
        }

        // If the destination path isnt cached, compute it. If it is cached, validate it
        if (!pathCache.get(from).containsKey(to) || !validatePath(pathCache.get(from).get(to))) {
            NetworkPath path = computePath(from, to);

            if (path != null) {
                pathCache.get(from).put(to, path);
            } else {
                return null;
            }
        }

        // Return the path
        return pathCache.get(from).get(to);
    }

    public boolean validatePath(NetworkPath path) {
        for (class_63 point : path.path) {
            if (!network.components.containsKey(point)) {
                return false;
            }
        }

        return network.isPathValid(path);
    }

    public NetworkPath computePath(class_63 from, class_63 to) {
        // Calculate Path
        ObjectSet<class_63> availibleNodes = network.getNonEdgeNodes().keySet();
        availibleNodes.add(from);
        availibleNodes.add(to);
        AStar aStar = new AStar(from, to, availibleNodes.toArray(new class_63[0]));
        class_63[] path = aStar.calculate();

        if (path == null || path.length == 0) {
            return null;
        }

        // Calculate Path Cost
        int cost = 0;
        for (class_63 pos : path) {
            if (network.world.getBlockState(pos.field_1482, pos.field_1483, pos.field_1484).getBlock() instanceof NetworkComponent component) {
                cost += component.getPathingCost(network.world, pos.field_1482, pos.field_1483, pos.field_1484, network);
            }
        }

        // Determine the face
        class_63 end = path[path.length - 1];
        class_63 beforeEnd = path[path.length - 2];

        Direction endFace = null;
        for (Direction dir : Direction.values()) {
            if (beforeEnd.field_1482 + dir.getOffsetX() == end.field_1482 && beforeEnd.field_1483 + dir.getOffsetY() == end.field_1483 && beforeEnd.field_1484 + dir.getOffsetZ() == end.field_1484) {
                endFace = dir.getOpposite();
            }
        }

        Direction startFace = null;

        if (path.length >= 2) {
            class_63 start = path[0];
            class_63 afterStart = path[1];

            for (Direction dir : Direction.values()) {
                if (start.field_1482 + dir.getOffsetX() == afterStart.field_1482 && start.field_1483 + dir.getOffsetY() == afterStart.field_1483 && start.field_1484 + dir.getOffsetZ() == afterStart.field_1484) {
                    startFace = dir;
                }
            }
        }


        // Return path
        return new NetworkPath(from, startFace, to, endFace, path, cost);
    }
}
