/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.HashMap;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkComponent;
import net.danygames2014.nyalib.network.NetworkPath;
import net.danygames2014.nyalib.util.AStar;
import net.minecraft.class_17;
import net.minecraft.class_63;
import net.modificationstation.stationapi.api.util.math.Direction;

public class NetworkPathManager {
    Network network;
    HashMap<class_63, HashMap<class_63, NetworkPath>> pathCache;

    private NetworkPathManager() {
    }

    public NetworkPathManager(Network network) {
        this.network = network;
        this.pathCache = new HashMap();
    }

    public void clearCache() {
        this.pathCache.clear();
    }

    public NetworkPath getPath(class_63 from, class_63 to) {
        if (!this.pathCache.containsKey(from)) {
            this.pathCache.put(from, new HashMap());
        }
        if (!this.pathCache.get(from).containsKey(to) || !this.validatePath(this.pathCache.get(from).get(to))) {
            NetworkPath path = this.computePath(from, to);
            if (path != null) {
                this.pathCache.get(from).put(to, path);
            } else {
                return null;
            }
        }
        return this.pathCache.get(from).get(to);
    }

    public boolean validatePath(NetworkPath path) {
        for (class_63 point : path.path) {
            if (this.network.components.containsKey(point)) continue;
            return false;
        }
        return this.network.isPathValid(path);
    }

    /*
     * WARNING - void declaration
     */
    public NetworkPath computePath(class_63 from, class_63 to) {
        void var10_15;
        ObjectSet availibleNodes = this.network.getNonEdgeNodes().keySet();
        availibleNodes.add((Object)from);
        availibleNodes.add((Object)to);
        AStar aStar = new AStar(from, to, (class_63[])availibleNodes.toArray((Object[])new class_63[0]));
        class_63[] path = aStar.calculate();
        if (path == null || path.length == 0) {
            return null;
        }
        int cost = 0;
        for (class_63 class_632 : path) {
            class_17 class_172 = this.network.world.getBlockState(class_632.field_1482, class_632.field_1483, class_632.field_1484).getBlock();
            if (!(class_172 instanceof NetworkComponent)) continue;
            NetworkComponent component = (NetworkComponent)class_172;
            cost += component.getPathingCost(this.network.world, class_632.field_1482, class_632.field_1483, class_632.field_1484, this.network);
        }
        class_63 end = path[path.length - 1];
        class_63 beforeEnd = path[path.length - 2];
        Direction endFace = null;
        for (Direction dir : Direction.values()) {
            if (beforeEnd.field_1482 + dir.getOffsetX() != end.field_1482 || beforeEnd.field_1483 + dir.getOffsetY() != end.field_1483 || beforeEnd.field_1484 + dir.getOffsetZ() != end.field_1484) continue;
            endFace = dir.getOpposite();
        }
        Object var10_14 = null;
        if (path.length >= 2) {
            class_63 start = path[0];
            class_63 afterStart = path[1];
            for (Direction dir : Direction.values()) {
                if (start.field_1482 + dir.getOffsetX() != afterStart.field_1482 || start.field_1483 + dir.getOffsetY() != afterStart.field_1483 || start.field_1484 + dir.getOffsetZ() != afterStart.field_1484) continue;
                Direction direction = dir;
            }
        }
        return new NetworkPath(from, (Direction)var10_15, to, endFace, path, cost);
    }
}

