/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkComponentEntry;
import net.danygames2014.nyalib.network.NetworkManager;
import net.danygames2014.nyalib.network.NetworkType;
import net.danygames2014.nyalib.network.NetworkTypeRegistry;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_8;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;
import org.jetbrains.annotations.Nullable;

public interface NetworkComponent {
    public NetworkType getNetworkType();

    default public ArrayList<NetworkType> getNetworkTypes() {
        ArrayList<NetworkType> types = new ArrayList<NetworkType>();
        types.add(this.getNetworkType());
        return types;
    }

    default public NetworkComponentEntry getEntry(class_18 world, int x, int y, int z, NetworkType networkType) {
        Network net = NetworkManager.getAt(world.field_216, x, y, z, networkType.identifier);
        if (net != null) {
            return net.getEntry(x, y, z);
        }
        return null;
    }

    default public HashMap<Network, NetworkComponentEntry> getEntries(class_18 world, int x, int y, int z) {
        ArrayList<NetworkType> validNetworkTypes = this.getNetworkTypes();
        HashMap<Network, NetworkComponentEntry> entries = new HashMap<Network, NetworkComponentEntry>();
        for (Map.Entry<Identifier, ArrayList<Network>> networkTypes : NetworkManager.getNetworks(world.field_216).entrySet()) {
            if (!validNetworkTypes.contains(NetworkTypeRegistry.get(networkTypes.getKey()))) continue;
            for (Network network : networkTypes.getValue()) {
                if (!network.isAt(x, y, z)) continue;
                entries.put(network, network.getEntry(x, y, z));
            }
        }
        return entries;
    }

    default public boolean canConnectTo(class_18 world, int x, int y, int z, @Nullable Network network, Direction direction) {
        return true;
    }

    default public int getPathingCost(class_18 world, int x, int y, int z, @Nullable Network network) {
        return 1;
    }

    default public void update(class_18 world, int x, int y, int z, Network network) {
    }

    default public void onAddedToNet(class_18 world, int x, int y, int z, Network network) {
    }

    default public void onRemovedFromNet(class_18 world, int x, int y, int z, Network network) {
    }

    default public <T extends class_17> void addToNet(class_18 world, int x, int y, int z, T component) {
        if (!world.field_180) {
            NetworkManager.addBlock(world, x, y, z, component);
        }
    }

    default public <T extends class_17> void removeFromNet(class_18 world, int x, int y, int z, T component) {
        if (!world.field_180) {
            NetworkManager.removeBlock(world, x, y, z, component);
        }
    }

    default public void writeNbt(class_18 world, int x, int y, int z, Network network, class_8 nbt) {
    }

    default public void readNbt(class_18 world, int x, int y, int z, Network network, class_8 nbt) {
    }
}

