/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.network;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.danygames2014.nyalib.NyaLib;
import net.danygames2014.nyalib.network.Network;
import net.danygames2014.nyalib.network.NetworkManager;
import net.mine_diver.unsafeevents.listener.EventListener;
import net.minecraft.class_454;
import net.minecraft.class_8;
import net.minecraft.class_83;
import net.modificationstation.stationapi.api.event.world.WorldEvent;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.SideUtil;

public class NetworkLoader {
    public static boolean readOnly = false;
    public static boolean isRemote = false;

    @EventListener
    public void saveNetworks(WorldEvent.Save event) {
        NyaLib.LOGGER.debug("Saving NyaLib networks");
        if (isRemote) {
            return;
        }
        if (readOnly) {
            NyaLib.LOGGER.warn("Saving NyaLib networks prevented as they are read-only due to error when loading.");
            return;
        }
        try {
            File file = event.world.field_219.method_1736("nyalib_networks");
            class_8 tag = new class_8();
            if (file.exists()) {
                tag = class_83.method_338((InputStream)new FileInputStream(file));
            }
            tag.method_1015("next_id", NetworkManager.NEXT_ID.get());
            NetworkManager.writeNbt(event.world, tag);
            class_83.method_336((class_8)tag, (OutputStream)new FileOutputStream(file));
            NyaLib.LOGGER.debug("Saved NyaLib networks");
        }
        catch (Exception e) {
            NyaLib.LOGGER.error("Error occured while saving NyaLib Networks", (Throwable)e);
        }
    }

    @EventListener
    public void loadNetworks(WorldEvent.Init event) {
        NyaLib.LOGGER.debug("Loading NyaLib networks");
        if (event.world == null) {
            return;
        }
        isRemote = (Boolean)SideUtil.get(() -> event.world instanceof class_454, () -> false);
        if (isRemote) {
            NyaLib.LOGGER.info("Skipping loading NyaLib networks because of the world being remote");
            return;
        }
        try {
            File file = event.world.field_219.method_1736("nyalib_networks");
            if (file.exists()) {
                class_8 tag = class_83.method_338((InputStream)new FileInputStream(file));
                NetworkManager.NETWORKS = new HashMap();
                NetworkManager.removeQueue = new ArrayList();
                NetworkManager.NEXT_ID.set(tag.method_1027("next_id"));
                NetworkManager.readNbt(event.world, tag);
                int networkCount = 0;
                for (HashMap<Identifier, ArrayList<Network>> dimEntries : NetworkManager.NETWORKS.values()) {
                    for (ArrayList<Network> networks : dimEntries.values()) {
                        networkCount += networks.size();
                    }
                }
                NyaLib.LOGGER.info("Loaded {} NyaLib networks", (Object)networkCount);
            }
        }
        catch (Exception e) {
            NyaLib.LOGGER.error("Error occured while loading NyaLib Networks, networks are now read only to prevent saving corrupted data", (Throwable)e);
            readOnly = true;
        }
    }
}

