package net.danygames2014.nyalib.block;

import net.minecraft.class_14;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;

import java.util.ArrayList;
import java.util.List;

public class SlabBlockTemplate extends TemplateBlock {

    public static final EnumProperty<SlabType> SLAB_TYPE = EnumProperty.of("slab_type", SlabType.class);

    public SlabBlockTemplate(Identifier identifier, class_17 baseBlock) {
        this(identifier, baseBlock, null);
    }

    public SlabBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        super(identifier, baseBlock.field_1900);
        this.method_1578(0.0F, 0.0F, 0.0F, 1.0F, 0.5F, 1.0F);
        this.method_1590(0);
        if (texture != null) {
            TemplateBlockRegistry.registerSlab(identifier, texture);
        }
    }

    @Override
    public void method_1616(class_14 blockView, int x, int y, int z) {
        if (!(blockView instanceof BlockStateView view)) {
            return;
        }

        switch (view.getBlockState(x, y, z).get(SLAB_TYPE)) {
            case BOTTOM -> this.method_1578(0.0F, 0.0F, 0.0F, 1.0F, 0.5F, 1.0F);
            case TOP -> this.method_1578(0.0F, 0.5F, 0.0F, 1.0F, 1.0F, 1.0F);
            case DOUBLE -> this.method_1578(0.0F, 0.0F, 0.0F, 1.0F, 1.0F, 1.0F);
            default ->
                    throw new IllegalStateException("Unexpected value: " + ((class_18) blockView).getBlockState(x, y, z).get(SLAB_TYPE));
        }
    }

    @Override
    public class_25 method_1624(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);

        if (!state.isOf(this)) {
            return class_25.method_87(x + 0.0F, y + 0.0F, z + 0.0F, x + 1.0F, y + 0.5F, z + 1.0F);
        }

        return switch (world.getBlockState(x, y, z).get(SLAB_TYPE)) {
            case BOTTOM -> class_25.method_87(x + 0.0F, y + 0.0F, z + 0.0F, x + 1.0F, y + 0.5F, z + 1.0F);
            case TOP -> class_25.method_87(x + 0.0F, y + 0.5F, z + 0.0F, x + 1.0F, y + 1.0F, z + 1.0F);
            case DOUBLE -> class_25.method_87(x + 0.0F, y + 0.0F, z + 0.0F, x + 1.0F, y + 1.0F, z + 1.0F);
        };
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(SLAB_TYPE);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        BlockState state = getDefaultState();
        Direction side = context.getSide();

        if (side == Direction.DOWN) {
            return state.with(SLAB_TYPE, SlabType.TOP);
        } else {
            return state.with(SLAB_TYPE, SlabType.BOTTOM);
        }
    }

    @Override
    public void method_1606(class_18 world, int x, int y, int z, int direction) {
        // 1 = Placed on bottom face
        // 0 = Placed on top face

        if (!(world.getBlockState(x, y, z).get(SLAB_TYPE) == SlabType.DOUBLE)) {
            if (direction == 1 || direction == 0) {
                int offset = direction == 0 ? 1 : -1;

                if (world.method_1776(x, y + offset, z) == this.field_1915) {
                    if (direction == 0 && world.getBlockState(x, y + offset, z).get(SLAB_TYPE) == SlabType.TOP) {
                        world.method_229(x, y, z, 0);
                        world.setBlockState(x, y + offset, z, this.getDefaultState().with(SLAB_TYPE, SlabType.DOUBLE));
                    } else if (direction == 1 && world.getBlockState(x, y + offset, z).get(SLAB_TYPE) == SlabType.BOTTOM) {
                        world.method_229(x, y, z, 0);
                        world.setBlockState(x, y + offset, z, this.getDefaultState().with(SLAB_TYPE, SlabType.DOUBLE));
                    }
                }
            }
        }
    }

    @Override
    public List<class_31> getDropList(class_18 world, int x, int y, int z, BlockState state, int meta) {
        ArrayList<class_31> drops = new ArrayList<>();
        if (state.get(SLAB_TYPE) == SlabType.DOUBLE) {
            drops.add(new class_31(this, 2));
            return drops;
        } else {
            drops.add(new class_31(this, 1));
            return drops;
        }
    }

    @Override
    public boolean method_1623() {
        return false;
    }

    @Override
    public boolean method_1620() {
        return false;
    }
}
