package net.danygames2014.nyalib.block;

import java.util.ArrayList;
import net.minecraft.class_31;

public class TemplateBlockRecipeRegistry {
    public static final ArrayList<Entry> shapedEntries = new ArrayList<>();
    public static final ArrayList<Entry> shapelessEntries = new ArrayList<>();
    public static final ArrayList<Runnable> recipeCallbacks = new ArrayList<>();
    
    public static void registerRecipeCallback(Runnable runnable) {
        recipeCallbacks.add(runnable);
    }
    
    public static void registerShaped(class_31 output, Object... input) {
        shapedEntries.add(new Entry(output, input));
    }
    
    public static void registerShapeless(class_31 output, Object... ingredients) {
        shapelessEntries.add(new Entry(output, ingredients));
    }
    
    @SuppressWarnings("ClassCanBeRecord")
    public static class Entry {
        public final class_31 output;
        public final Object[] ingredients;

        public Entry(class_31 output, Object... ingredients) {
            this.output = output;
            this.ingredients = ingredients;
        }
    }
}

