/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.block;

import net.danygames2014.nyalib.block.FenceBlockTemplate;
import net.danygames2014.nyalib.block.FenceGateBlockTemplate;
import net.danygames2014.nyalib.block.PaneBlockTemplate;
import net.danygames2014.nyalib.block.TemplateBlockRegistry;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_229;
import net.minecraft.class_25;
import net.minecraft.class_494;
import net.minecraft.class_619;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.StringIdentifiable;
import net.modificationstation.stationapi.api.util.math.Direction;

public class WallBlockTemplate
extends TemplateBlock {
    public static final EnumProperty<WallType> EAST = EnumProperty.of((String)"east", WallType.class);
    public static final EnumProperty<WallType> WEST = EnumProperty.of((String)"west", WallType.class);
    public static final EnumProperty<WallType> NORTH = EnumProperty.of((String)"north", WallType.class);
    public static final EnumProperty<WallType> SOUTH = EnumProperty.of((String)"south", WallType.class);
    public static final BooleanProperty UP = BooleanProperty.of((String)"up");

    public WallBlockTemplate(Identifier identifier, class_17 baseBlock, class_15 material, Identifier texture) {
        super(identifier, material);
        if (texture != null) {
            TemplateBlockRegistry.registerWall(identifier, texture);
        }
    }

    public WallBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        this(identifier, baseBlock, baseBlock.field_1900, texture);
    }

    public WallBlockTemplate(Identifier identifier, class_17 baseBlock) {
        this(identifier, baseBlock, null);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{EAST, WEST, NORTH, SOUTH, UP});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getPlacementState(context).with(EAST, (Comparable)((Object)WallType.NONE))).with(WEST, (Comparable)((Object)WallType.NONE))).with(NORTH, (Comparable)((Object)WallType.NONE))).with(SOUTH, (Comparable)((Object)WallType.NONE))).with((Property)UP, (Comparable)Boolean.valueOf(true));
    }

    public void method_1611(class_18 world, int x, int y, int z) {
        this.updateConnections(world, x, y, z);
        super.method_1611(world, x, y, z);
    }

    public void method_1609(class_18 world, int x, int y, int z, int id) {
        this.updateConnections(world, x, y, z);
        super.method_1609(world, x, y, z, id);
    }

    public void updateConnections(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return;
        }
        state = this.getWallState(world, x, y, z, state, Direction.EAST, EAST);
        state = this.getWallState(world, x, y, z, state, Direction.WEST, WEST);
        state = this.getWallState(world, x, y, z, state, Direction.NORTH, NORTH);
        state = this.getWallState(world, x, y, z, state, Direction.SOUTH, SOUTH);
        if ((state = (BlockState)state.with((Property)UP, (Comparable)Boolean.valueOf(true))).get(EAST) == WallType.NONE && state.get(WEST) == WallType.NONE && state.get(NORTH) != WallType.NONE && state.get(SOUTH) != WallType.NONE) {
            state = (BlockState)state.with((Property)UP, (Comparable)Boolean.valueOf(false));
        } else if (state.get(NORTH) == WallType.NONE && state.get(SOUTH) == WallType.NONE && state.get(EAST) != WallType.NONE && state.get(WEST) != WallType.NONE) {
            state = (BlockState)state.with((Property)UP, (Comparable)Boolean.valueOf(false));
        }
        if (this.canConnectPost(world.getBlockState(x, y + 1, z))) {
            state = (BlockState)state.with((Property)UP, (Comparable)Boolean.valueOf(true));
        }
        world.setBlockStateWithNotify(x, y, z, state);
    }

    public boolean canConnectPost(BlockState state) {
        if (state.isOf((class_17)this)) {
            return (Boolean)state.get((Property)UP);
        }
        class_17 block = state.getBlock();
        return block instanceof class_494 || block instanceof class_619 || block instanceof class_229 || block instanceof FenceBlockTemplate;
    }

    public boolean canConnectTo(BlockState state) {
        if (state.isAir()) {
            return false;
        }
        class_17 block = state.getBlock();
        if (block instanceof WallBlockTemplate || block instanceof FenceBlockTemplate || block instanceof FenceGateBlockTemplate || block instanceof class_229 || block instanceof PaneBlockTemplate) {
            return true;
        }
        return state.getMaterial().method_897() && state.getBlock().method_1623();
    }

    private BlockState getWallState(class_18 world, int x, int y, int z, BlockState state, Direction side, EnumProperty<WallType> property) {
        if (this.canConnectTo(world.getBlockState(x + side.getOffsetX(), y, z + side.getOffsetZ()))) {
            state = (BlockState)state.with(property, (Comparable)((Object)WallType.LOW));
            if (this.canConnectTo(world.getBlockState(x, y + 1, z)) && this.canConnectTo(world.getBlockState(x + side.getOffsetX(), y + 1, z + side.getOffsetZ()))) {
                state = (BlockState)state.with(property, (Comparable)((Object)WallType.TALL));
            }
        } else {
            state = (BlockState)state.with(property, (Comparable)((Object)WallType.NONE));
        }
        return state;
    }

    public class_25 generateBox(class_18 world, int x, int y, int z, boolean collider) {
        BlockState state = world.getBlockState(x, y, z);
        if (!(state.getBlock() instanceof WallBlockTemplate)) {
            return null;
        }
        class_25 box = class_25.method_87((double)(state.get(NORTH) != WallType.NONE ? 0.0 : 0.25), (double)0.0, (double)(state.get(EAST) != WallType.NONE ? 0.0 : 0.25), (double)(state.get(SOUTH) != WallType.NONE ? 1.0 : 0.75), (double)1.0, (double)(state.get(WEST) != WallType.NONE ? 1.0 : 0.75));
        box.field_129 += (double)x;
        box.field_130 += (double)y;
        box.field_131 += (double)z;
        box.field_132 += (double)x;
        box.field_133 += (double)y;
        box.field_134 += (double)z;
        if (collider) {
            box.field_133 += 0.5;
        }
        return box;
    }

    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return this.generateBox(world, x, y, z, true);
    }

    public class_25 method_1622(class_18 world, int x, int y, int z) {
        return this.generateBox(world, x, y, z, false);
    }

    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    public static enum WallType implements StringIdentifiable
    {
        NONE("none"),
        LOW("low"),
        TALL("tall");

        public final String id;

        private WallType(String id) {
            this.id = id;
        }

        public String asString() {
            return this.id;
        }
    }
}

