package net.danygames2014.nyalib.block;

import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_229;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class PaneBlockTemplate extends TemplateBlock {
    // TODO: Proper bounding & collision Box
    
    public PaneBlockTemplate(Identifier identifier, class_17 baseBlock, class_15 material, Identifier texture, Identifier edgeTexture) {
        super(identifier, material);
        if(texture != null) {
            TemplateBlockRegistry.registerPane(identifier, texture, edgeTexture);
        }
    }
    
    public PaneBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture, Identifier edgeTexture) {
        this(identifier, baseBlock, baseBlock.field_1900, texture, edgeTexture);
    }
    
    public PaneBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        this(identifier, baseBlock, texture, texture);
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(Properties.NORTH, Properties.SOUTH, Properties.EAST, Properties.WEST);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        return super.getPlacementState(context)
                .with(Properties.EAST, false)
                .with(Properties.WEST, false)
                .with(Properties.NORTH, false)
                .with(Properties.SOUTH, false);
    }

    @Override
    public void method_1611(class_18 world, int x, int y, int z) {
        updateConnections(world, x, y, z);
        super.method_1611(world, x, y, z);
    }

    @Override
    public void method_1609(class_18 world, int x, int y, int z, int id) {
        updateConnections(world, x, y, z);
        super.method_1609(world, x, y, z, id);
    }

    public void updateConnections(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        
        if (!state.isOf(this)) {
            return;
        }

        state = getPaneState(world, x, y, z, state, Direction.EAST, Properties.EAST);
        state = getPaneState(world, x, y, z, state, Direction.WEST, Properties.WEST);
        state = getPaneState(world, x, y, z, state, Direction.NORTH,Properties.NORTH);
        state = getPaneState(world, x, y, z, state, Direction.SOUTH,Properties.SOUTH);

        world.setBlockStateWithNotify(x, y, z, state);
    }

    public boolean canConnectTo(BlockState state) {
        if (state.isAir()) {
            return false;
        }
        
        class_17 block = state.getBlock();
        if (block instanceof WallBlockTemplate || block instanceof FenceBlockTemplate || block instanceof FenceGateBlockTemplate || block instanceof class_229 || block instanceof PaneBlockTemplate) {
            return true;
        }

        if (state.getMaterial().method_897() && state.getBlock().method_1623()) {
            return true;
        }

        return false;
    }

    private BlockState getPaneState(class_18 world, int x, int y, int z, BlockState state, Direction side, BooleanProperty property) {
        return state.with(property, canConnectTo(world.getBlockState(x + side.getOffsetX(), y, z + side.getOffsetZ())));
    }

    @Override
    public boolean method_1623() {
        return false;
    }

    @Override
    public boolean method_1620() {
        return false;
    }
}
