package net.danygames2014.nyalib.block;

import net.danygames2014.nyalib.sound.SoundHelper;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.StringIdentifiable;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;

import java.util.Random;

@SuppressWarnings("DuplicatedCode")
public class ButtonBlockTemplate extends TemplateBlock {
    public static final EnumProperty<ButtonType> BUTTON_TYPE = EnumProperty.of("type", ButtonType.class);
    public class_17 baseBlock;

    public ButtonBlockTemplate(Identifier identifier, class_17 baseBlock, class_15 material, Identifier texture) {
        super(identifier, material);
        this.baseBlock = baseBlock;
        this.method_1584(true);
        if (texture != null) {
            TemplateBlockRegistry.registerButton(identifier, texture);
        }
    }

    public ButtonBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        this(identifier, baseBlock, baseBlock.field_1900, texture);
    }

    public ButtonBlockTemplate(Identifier identifier, class_17 baseBlock) {
        this(identifier, baseBlock, null);
    }
    
//    public ButtonBlockTemplate registerRecipe() {
//        TemplateBlockRecipeRegistry.registerRecipeCallback(() -> {
//            TemplateBlockRecipeRegistry.registerShapeless(new ItemStack(this, 1), baseBlock);
//        });
//        return this;
//    }

    // Blockstate Properties
    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(BUTTON_TYPE);
        builder.add(Properties.HORIZONTAL_FACING);
        builder.add(Properties.POWERED);
    }

    // Placement
    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        BlockState state = getDefaultState();

        switch (context.getSide()) {
            case UP -> {
                state = state.with(BUTTON_TYPE, ButtonType.FLOOR);
                state = state.with(Properties.HORIZONTAL_FACING, context.getHorizontalPlayerFacing().getOpposite());
            }

            case DOWN -> {
                state = state.with(BUTTON_TYPE, ButtonType.CEILING);
                state = state.with(Properties.HORIZONTAL_FACING, context.getHorizontalPlayerFacing().getOpposite());
            }

            case NORTH, SOUTH, EAST, WEST -> {
                state = state.with(BUTTON_TYPE, ButtonType.WALL);
                state = state.with(Properties.HORIZONTAL_FACING, context.getSide());
            }
        }

        state = state.with(Properties.POWERED, false);

        return state;
    }

    public boolean checkPlacementValidity(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(new class_339(x, y, z));

        switch (state.get(BUTTON_TYPE)) {
            case CEILING -> {
                return canPlaceOn(world, x, y + 1, z);
            }
            case FLOOR -> {
                return canPlaceOn(world, x, y - 1, z);
            }
            case WALL -> {
                Direction side = state.get(Properties.HORIZONTAL_FACING).getOpposite();
                return canPlaceOn(world, x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ());
            }
        }

        return false;
    }

    public boolean canPlaceOn(class_18 world, int x, int y, int z) {
        return world.method_1780(x, y, z);
    }

    // Ticking & Updates
    @Override
    public int method_1565() {
        return 20;
    }

    @Override
    public void method_1602(class_18 world, int x, int y, int z, Random random) {
        if (world.field_180) {
            return;
        }

        BlockState state = world.getBlockState(x, y, z);
        if (state.get(Properties.POWERED)) {
            world.setBlockStateWithNotify(x, y, z, state.with(Properties.POWERED, false));

            switch (state.get(BUTTON_TYPE)) {
                case CEILING -> {
                    world.method_244(x, y + 1, z, this.field_1915);
                }
                case FLOOR -> {
                    world.method_244(x, y - 1, z, this.field_1915);
                }
                case WALL -> {
                    Direction dir = state.get(Properties.HORIZONTAL_FACING).getOpposite();
                    world.method_244(x + dir.getOffsetX(), y + dir.getOffsetY(), z + dir.getOffsetZ(), this.field_1915);
                }
            }

            SoundHelper.playSound(world, x + 0.5D, y + 0.5D, z + 0.5D, "random.click", 0.3F, 0.5F);
        }
    }

    @Override
    public void method_1609(class_18 world, int x, int y, int z, int id) {
        if (!world.field_180) {
            if (!checkPlacementValidity(world, x, y, z)) {
                this.method_1592(world, x, y, z, 0);
                world.setBlockState(x, y, z, States.AIR.get());
            }
        }
    }

    // Button Pressing
    @Override
    public void method_1610(class_18 world, int x, int y, int z, class_54 player) {
        this.method_1608(world, x, y, z, player);
    }

    @Override
    public boolean method_1608(class_18 world, int x, int y, int z, class_54 player) {
        if (world.field_180) {
            return true;
        }

        BlockState state = world.getBlockState(x, y, z);

        // This can happen if the block is broken but the breaking action still triggers the use action
        if (!state.isOf(this)) {
            return false;
        }

        // If the button isn't already pressed, press it
        if (!state.get(Properties.POWERED)) {
            SoundHelper.playSound(world, x + 0.5D, y + 0.5D, z + 0.5D, "random.click", 0.3F, 0.6F);

            world.setBlockStateWithNotify(x, y, z, state.cycle(Properties.POWERED));

            switch (state.get(BUTTON_TYPE)) {
                case CEILING -> {
                    world.method_244(x, y + 1, z, this.field_1915);
                }
                case FLOOR -> {
                    world.method_244(x, y - 1, z, this.field_1915);
                }
                case WALL -> {
                    Direction dir = state.get(Properties.HORIZONTAL_FACING).getOpposite();
                    world.method_244(x + dir.getOffsetX(), y + dir.getOffsetY(), z + dir.getOffsetZ(), this.field_1915);
                }
            }

            world.method_216(x, y, z, this.field_1915, this.method_1565());
        }

        return true;
    }

    // Redstone Behavior
    @Override
    public boolean method_1569() {
        return true;
    }

    @Override
    public boolean method_1568(class_14 blockView, int x, int y, int z, int direction) {
        if (blockView instanceof BlockStateView stateView) {
            return stateView.getBlockState(x, y, z).get(Properties.POWERED);
        }
        return false;
    }

    @Override
    public boolean method_1570(class_18 world, int x, int y, int z, int direction) {
        BlockState state = world.getBlockState(x, y, z);

        if (state.get(Properties.POWERED)) {
            switch (state.get(BUTTON_TYPE)) {
                case CEILING -> {
                    return Direction.byId(direction) == Direction.DOWN;
                }
                case FLOOR -> {
                    return Direction.byId(direction) == Direction.UP;
                }
                case WALL -> {
                    return state.get(Properties.HORIZONTAL_FACING) == Direction.byId(direction);
                }
            }
        }

        return false;
    }

    // Update neighbors on break
    @Override
    public void onStateReplaced(BlockState state, class_18 world, class_339 pos, BlockState newState) {
        // If the button has been broken, send a block update to neighbors
        if (state.isOf(this) && newState.isAir()) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();

            switch (state.get(BUTTON_TYPE)) {
                case CEILING -> {
                    world.method_244(x, y + 1, z, this.field_1915);
                }
                case FLOOR -> {
                    world.method_244(x, y - 1, z, this.field_1915);
                }
                case WALL -> {
                    Direction dir = state.get(Properties.HORIZONTAL_FACING).getOpposite();
                    world.method_244(x + dir.getOffsetX(), y + dir.getOffsetY(), z + dir.getOffsetZ(), this.field_1915);
                }
            }
            world.method_216(x, y, z, this.field_1915, this.method_1565());
        }
    }

    // Collision Shape
    @Override
    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return null;
    }

    // Bounding Box
    @Override
    public void method_1616(class_14 blockView, int x, int y, int z) {
        if (!(blockView instanceof BlockStateView view)) {
            return;
        }

        BlockState state = view.getBlockState(x, y, z);
        
        if (!state.isOf(this)) {
            return;
        }

        switch (state.get(BUTTON_TYPE)) {
            case CEILING -> {
                switch (state.get(Properties.HORIZONTAL_FACING)) {
                    case EAST, WEST -> {
                        if (state.get(Properties.POWERED)) {
                            method_1578(0.3125F, 0.9375F, 0.375F, 0.6875F, 1.0F, 0.625F);
                        } else {
                            method_1578(0.3125F, 0.875F, 0.375F, 0.6875F, 1.0F, 0.625F);
                        }
                    }
                    case NORTH, SOUTH -> {
                        if (state.get(Properties.POWERED)) {
                            method_1578(0.375F, 0.9375F, 0.3125F, 0.625F, 1.0F, 0.6875F);
                        } else {
                            method_1578(0.375F, 0.875F, 0.3125F, 0.625F, 1.0F, 0.6875F);
                        }
                    }
                }
            }

            case FLOOR -> {
                switch (state.get(Properties.HORIZONTAL_FACING)) {
                    case EAST, WEST -> {
                        if (state.get(Properties.POWERED)) {
                            method_1578(0.3125F, 0.0F, 0.375F, 0.6875F, 0.0625F, 0.625F);
                        } else {
                            method_1578(0.3125F, 0.0F, 0.375F, 0.6875F, 0.125F, 0.625F);
                        }
                    }
                    case NORTH, SOUTH -> {
                        if (state.get(Properties.POWERED)) {
                            method_1578(0.375F, 0.0F, 0.3125F, 0.625F, 0.0625F, 0.6875F);
                        } else {
                            method_1578(0.375F, 0.0F, 0.3125F, 0.625F, 0.125F, 0.6875F);
                        }
                    }
                }
            }

            case WALL -> {
                switch (state.get(Properties.HORIZONTAL_FACING)) {
                    case EAST -> {
                        if (state.get(Properties.POWERED)) {
                            method_1578(0.3125F, 0.375F, 1.0F, 0.6875F, 0.625F, 0.9375F);
                        } else {
                            method_1578(0.3125F, 0.375F, 1.0F, 0.6875F, 0.625F, 0.875F);
                        }
                    }
                    case WEST -> {
                        if (state.get(Properties.POWERED)) {
                            method_1578(0.3125F, 0.375F, 0.0F, 0.6875F, 0.625F, 0.0625F);
                        } else {
                            method_1578(0.3125F, 0.375F, 0.0F, 0.6875F, 0.625F, 0.125F);
                        }
                    }
                    case NORTH -> {
                        if (state.get(Properties.POWERED)) {
                            method_1578(0.9375F, 0.375F, 0.3125F, 1.0F, 0.625F, 0.6875F);
                        } else {
                            method_1578(0.875F, 0.375F, 0.3125F, 1.0F, 0.625F, 0.6875F);
                        }
                    }
                    case SOUTH -> {
                        if (state.get(Properties.POWERED)) {
                            method_1578(0.0F, 0.375F, 0.3125F, 0.0625F, 0.625F, 0.6875F);
                        } else {
                            method_1578(0.0F, 0.375F, 0.3125F, 0.125F, 0.625F, 0.6875F);
                        }
                    }
                }
            }
        }
    }

    // Rendering
    @Override
    public boolean method_1623() {
        return false;
    }

    @Override
    public boolean method_1620() {
        return false;
    }

    // Property Enum
    public enum ButtonType implements StringIdentifiable {
        CEILING("ceiling"),
        FLOOR("floor"),
        WALL("wall");

        public final String type;

        ButtonType(String type) {
            this.type = type;
        }

        @Override
        public String asString() {
            return type;
        }
    }
}
