package net.danygames2014.nyalib.block;

import net.danygames2014.nyalib.sound.SoundHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_127;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_389;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.world.BlockStateView;

import java.util.List;
import java.util.Random;

public class PressurePlateBlockTemplate extends TemplateBlock {
    public final class_389 activationRule;

    public PressurePlateBlockTemplate(Identifier identifier, class_17 baseBlock, class_389 activationRule, class_15 material, Identifier texture) {
        super(identifier, material);
        this.activationRule = activationRule;
        this.method_1584(true);
        this.method_1578(0.0625F, 0.0F, 0.0625F, 0.9375F, 0.03125F, 0.9375F);

        if (texture != null) {
            TemplateBlockRegistry.registerPressurePlate(identifier, texture);
        }
    }

    public PressurePlateBlockTemplate(Identifier identifier, class_17 baseBlock, class_389 activationRule, Identifier texture) {
        this(identifier, baseBlock, activationRule, baseBlock.field_1900, texture);
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(Properties.POWERED);
    }

    public int method_1565() {
        return 20;
    }

    public int method_1574() {
        return 1;
    }

    // Placement
    public boolean method_1567(class_18 world, int x, int y, int z) {
        return world.method_1780(x, y - 1, z);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        return super.getPlacementState(context).with(Properties.POWERED, false);
    }

    // LogIC
    public void method_1611(class_18 world, int x, int y, int z) {
    }

    public void method_1609(class_18 world, int x, int y, int z, int id) {
        if (!world.method_1780(x, y - 1, z)) {
            this.method_1592(world, x, y, z, world.method_1778(x, y, z));
            world.setBlockState(x, y, z, States.AIR.get());
        }
    }

    public void method_1602(class_18 world, int x, int y, int z, Random random) {
        if (!world.field_180) {
            if (isPressed(world, x, y, z)) {
                this.updatePlateState(world, x, y, z);
            }
        }
    }

    public void method_1630(class_18 world, int x, int y, int z) {
        if (isPressed(world, x, y, z)) {
            world.method_244(x, y, z, this.field_1915);
            world.method_244(x, y - 1, z, this.field_1915);
        }

        super.method_1630(world, x, y, z);
    }

    public void method_1615(class_18 world, int x, int y, int z, class_57 entity) {
        if (!world.field_180) {
            if (!isPressed(world, x, y, z)) {
                this.updatePlateState(world, x, y, z);
            }
        }
    }

    private void updatePlateState(class_18 world, int x, int y, int z) {
        @SuppressWarnings("rawtypes")
        List foundEntities = null;

        switch (this.activationRule) {
            case field_1505 -> {
                foundEntities = world.method_211(null, class_25.method_94((float) x + 0.125F, y, (float) z + 0.125F, (float) (x + 1) - 0.125F, y + 0.25F, (float) (z + 1) - 0.125F));
            }
            case field_1506 -> {
                foundEntities = world.method_175(class_127.class, class_25.method_94((float) x + 0.125F, y, (float) z + 0.125F, (float) (x + 1) - 0.125F, y + 0.25F, (float) (z + 1) - 0.125F));
            }
            case field_1507 -> {
                foundEntities = world.method_175(class_54.class, class_25.method_94((float) x + 0.125F, y, (float) z + 0.125F, (float) (x + 1) - 0.125F, y + 0.25F, (float) (z + 1) - 0.125F));
            }
        }

        boolean pressed = isPressed(world, x, y, z);
        boolean foundEntity = !foundEntities.isEmpty();
        BlockState state = world.getBlockState(x, y, z);

        if (foundEntity && !pressed) {
            world.setBlockStateWithNotify(x, y, z, state.with(Properties.POWERED, true));
            world.method_244(x, y, z, this.field_1915);
            world.method_244(x, y - 1, z, this.field_1915);
            SoundHelper.playSound(world, x + 0.5D, y + 0.1D, z + 0.5D, "random.click", 0.3F, 0.6F);
        }

        if (!foundEntity && pressed) {
            world.setBlockStateWithNotify(x, y, z, state.with(Properties.POWERED, false));
            world.method_244(x, y, z, this.field_1915);
            world.method_244(x, y - 1, z, this.field_1915);
            SoundHelper.playSound(world, x + 0.5D, y + 0.1D, z + 0.5D, "random.click", 0.3F, 0.5F);
        }

        if (foundEntity) {
            world.method_216(x, y, z, this.field_1915, this.method_1565());
        }

    }

    // Collision & Bounding Box
    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return null;
    }

    public void method_1616(class_14 blockView, int x, int y, int z) {
        if (isPressed(blockView, x, y, z)) {
            this.method_1578(0.0625F, 0.0F, 0.0625F, 0.9375F, 0.03125F, 0.9375F);
        } else {
            this.method_1578(0.0625F, 0.0F, 0.0625F, 0.9375F, 0.0625F, 0.9375F);
        }
    }

    // Redstone Behavior
    public boolean method_1568(class_14 blockView, int x, int y, int z, int direction) {
        return isPressed(blockView, x, y, z);
    }

    public boolean method_1570(class_18 world, int x, int y, int z, int direction) {
        return isPressed(world, x, y, z) && direction == 1;
    }

    public boolean method_1569() {
        return true;
    }

    // Rendering
    public boolean method_1620() {
        return false;
    }

    public boolean method_1623() {
        return false;
    }

    @Environment(EnvType.CLIENT)
    public void method_1605() {
        float var1 = 0.5F;
        float var2 = 0.125F;
        float var3 = 0.5F;
        this.method_1578(0.5F - var1, 0.5F - var2, 0.5F - var3, 0.5F + var1, 0.5F + var2, 0.5F + var3);
    }

    // Utility
    public boolean isPressed(class_14 blockView, int x, int y, int z) {
        if (blockView instanceof BlockStateView stateView) {
            BlockState state = stateView.getBlockState(x, y, z);

            if (!(state.getBlock() instanceof PressurePlateBlockTemplate)) {
                return false;
            }

            return state.get(Properties.POWERED);
        }

        return false;
    }
}
