package net.danygames2014.nyalib.block;

import net.danygames2014.nyalib.sound.SoundHelper;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.BooleanProperty;
import net.modificationstation.stationapi.api.state.property.DirectionProperty;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.math.Direction;

public class FenceGateBlockTemplate extends TemplateBlock {
    public static final BooleanProperty OPEN = BooleanProperty.of("open");
    public static final DirectionProperty FACING = DirectionProperty.of("facing", Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    public static final BooleanProperty IN_WALL = BooleanProperty.of("in_wall");

    public FenceGateBlockTemplate(Identifier identifier, class_17 baseBlock) {
        this(identifier, baseBlock, null);
    }

    public FenceGateBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        super(identifier, baseBlock.field_1900);
        this.method_1590(0);
        if (texture != null) {
            TemplateBlockRegistry.registerFenceGate(identifier, texture);
        }
    }

    @Override
    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(OPEN);
        builder.add(FACING);
        builder.add(IN_WALL);
    }

    @Override
    public BlockState getPlacementState(ItemPlacementContext context) {
        return this.getDefaultState().with(FACING, context.getHorizontalPlayerFacing()).with(OPEN, false).with(IN_WALL, false);
    }

    @Override
    public boolean method_1608(class_18 world, int x, int y, int z, class_54 player) {
        BlockState state = world.getBlockState(x, y, z);
        
        if (state.get(OPEN)) {
            world.setBlockStateWithNotify(x, y, z, state.with(OPEN, false));
            SoundHelper.playSound(world, x, y, z, getCloseSound(world, x, y, z), 1.0F, (world.field_214.nextFloat() * 0.1F) + 0.9F);
        } else {
            world.setBlockStateWithNotify(x, y, z, state.with(OPEN, true));
            SoundHelper.playSound(world, x, y, z, getOpenSound(world, x, y, z), 1.0F, (world.field_214.nextFloat() * 0.1F) + 0.9F);
        }
        
        world.method_246(x, y, z);
        return true;
    }

    public String getOpenSound(class_18 world, int x, int y, int z) {
        return "random.door_open";
    }

    public String getCloseSound(class_18 world, int x, int y, int z) {
        return "random.door_close";
    }

    @Override
    public void method_1609(class_18 world, int x, int y, int z, int id) {
        super.method_1609(world, x, y, z, id);
        updateInWall(world, x, y, z);
    }

    @Override
    public void method_1611(class_18 world, int x, int y, int z) {
        super.method_1611(world, x, y, z);
        updateInWall(world, x, y, z);
    }

    public void updateInWall(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(x, y, z);
        state = state.with(IN_WALL, false);

        for (Direction side : Direction.values()) {
            if (side.getHorizontal() != -1) {
                if (world.getBlockState(x + side.getOffsetX(), y, z + side.getOffsetZ()).getBlock() instanceof WallBlockTemplate) {
                    state = state.with(IN_WALL, true);
                    world.setBlockStateWithNotify(x, y, z, state);
                    return;
                }
            }
        }

        world.setBlockStateWithNotify(x, y, z, state);
    }

    public class_25 generateBox(class_18 world, int x, int y, int z, boolean collider) {
        BlockState state = world.getBlockState(x, y, z);

        if (!(state.getBlock() instanceof FenceGateBlockTemplate)) {
            return null;
        }

        Direction facing = state.get(FACING);
        boolean open = state.get(OPEN);

        if (collider && open) {
            return null;
        }

        class_25 box;
        if (facing.getId() == 4 || facing.getId() == 5) {
            box = class_25.method_87(0.375f, 0.0f, 0.0f, 0.625f, 1.0f, 1.0f);
        } else {
            box = class_25.method_87(0.0f, 0.0f, 0.375f, 1.0f, 1.0f, 0.625f);
        }

        box.field_129 += x;
        box.field_130 += y;
        box.field_131 += z;
        box.field_132 += x;
        box.field_133 += y;
        box.field_134 += z;

        if (collider) {
            box.field_133 += 0.5F;
        }

        return box;
    }

    @Override
    public class_25 method_1622(class_18 world, int x, int y, int z) {
        return generateBox(world, x, y, z, false);
    }

    @Override
    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return generateBox(world, x, y, z, true);
    }

    @Override
    public boolean method_1623() {
        return false;
    }

    @Override
    public boolean method_1620() {
        return false;
    }
}
