/*
 * Decompiled with CFR 0.152.
 */
package net.danygames2014.nyalib.block;

import java.util.Random;
import net.danygames2014.nyalib.block.TemplateBlockRegistry;
import net.danygames2014.nyalib.sound.SoundHelper;
import net.minecraft.class_14;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_25;
import net.minecraft.class_339;
import net.minecraft.class_54;
import net.modificationstation.stationapi.api.block.BlockState;
import net.modificationstation.stationapi.api.block.States;
import net.modificationstation.stationapi.api.item.ItemPlacementContext;
import net.modificationstation.stationapi.api.state.StateManager;
import net.modificationstation.stationapi.api.state.property.EnumProperty;
import net.modificationstation.stationapi.api.state.property.Properties;
import net.modificationstation.stationapi.api.state.property.Property;
import net.modificationstation.stationapi.api.template.block.TemplateBlock;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.StringIdentifiable;
import net.modificationstation.stationapi.api.util.math.Direction;
import net.modificationstation.stationapi.api.world.BlockStateView;

public class ButtonBlockTemplate
extends TemplateBlock {
    public static final EnumProperty<ButtonType> BUTTON_TYPE = EnumProperty.of((String)"type", ButtonType.class);
    public class_17 baseBlock;

    public ButtonBlockTemplate(Identifier identifier, class_17 baseBlock, class_15 material, Identifier texture) {
        super(identifier, material);
        this.baseBlock = baseBlock;
        this.method_1584(true);
        if (texture != null) {
            TemplateBlockRegistry.registerButton(identifier, texture);
        }
    }

    public ButtonBlockTemplate(Identifier identifier, class_17 baseBlock, Identifier texture) {
        this(identifier, baseBlock, baseBlock.field_1900, texture);
    }

    public ButtonBlockTemplate(Identifier identifier, class_17 baseBlock) {
        this(identifier, baseBlock, null);
    }

    public void appendProperties(StateManager.Builder<class_17, BlockState> builder) {
        super.appendProperties(builder);
        builder.add(new Property[]{BUTTON_TYPE});
        builder.add(new Property[]{Properties.HORIZONTAL_FACING});
        builder.add(new Property[]{Properties.POWERED});
    }

    public BlockState getPlacementState(ItemPlacementContext context) {
        BlockState state = this.getDefaultState();
        switch (context.getSide()) {
            case UP: {
                state = (BlockState)state.with(BUTTON_TYPE, (Comparable)((Object)ButtonType.FLOOR));
                state = (BlockState)state.with((Property)Properties.HORIZONTAL_FACING, (Comparable)context.getHorizontalPlayerFacing().getOpposite());
                break;
            }
            case DOWN: {
                state = (BlockState)state.with(BUTTON_TYPE, (Comparable)((Object)ButtonType.CEILING));
                state = (BlockState)state.with((Property)Properties.HORIZONTAL_FACING, (Comparable)context.getHorizontalPlayerFacing().getOpposite());
                break;
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                state = (BlockState)state.with(BUTTON_TYPE, (Comparable)((Object)ButtonType.WALL));
                state = (BlockState)state.with((Property)Properties.HORIZONTAL_FACING, (Comparable)context.getSide());
            }
        }
        state = (BlockState)state.with((Property)Properties.POWERED, (Comparable)Boolean.valueOf(false));
        return state;
    }

    public boolean checkPlacementValidity(class_18 world, int x, int y, int z) {
        BlockState state = world.getBlockState(new class_339(x, y, z));
        switch (((ButtonType)((Object)state.get(BUTTON_TYPE))).ordinal()) {
            case 0: {
                return this.canPlaceOn(world, x, y + 1, z);
            }
            case 1: {
                return this.canPlaceOn(world, x, y - 1, z);
            }
            case 2: {
                Direction side = ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)).getOpposite();
                return this.canPlaceOn(world, x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ());
            }
        }
        return false;
    }

    public boolean canPlaceOn(class_18 world, int x, int y, int z) {
        return world.method_1780(x, y, z);
    }

    public int method_1565() {
        return 20;
    }

    public void method_1602(class_18 world, int x, int y, int z, Random random) {
        if (world.field_180) {
            return;
        }
        BlockState state = world.getBlockState(x, y, z);
        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
            world.setBlockStateWithNotify(x, y, z, (BlockState)state.with((Property)Properties.POWERED, (Comparable)Boolean.valueOf(false)));
            switch (((ButtonType)((Object)state.get(BUTTON_TYPE))).ordinal()) {
                case 0: {
                    world.method_244(x, y + 1, z, this.field_1915);
                    break;
                }
                case 1: {
                    world.method_244(x, y - 1, z, this.field_1915);
                    break;
                }
                case 2: {
                    Direction dir = ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)).getOpposite();
                    world.method_244(x + dir.getOffsetX(), y + dir.getOffsetY(), z + dir.getOffsetZ(), this.field_1915);
                }
            }
            SoundHelper.playSound((class_18)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (String)"random.click", (float)0.3f, (float)0.5f);
        }
    }

    public void method_1609(class_18 world, int x, int y, int z, int id) {
        if (!world.field_180 && !this.checkPlacementValidity(world, x, y, z)) {
            this.method_1592(world, x, y, z, 0);
            world.setBlockState(x, y, z, (BlockState)States.AIR.get());
        }
    }

    public void method_1610(class_18 world, int x, int y, int z, class_54 player) {
        this.method_1608(world, x, y, z, player);
    }

    public boolean method_1608(class_18 world, int x, int y, int z, class_54 player) {
        if (world.field_180) {
            return true;
        }
        BlockState state = world.getBlockState(x, y, z);
        if (!state.isOf((class_17)this)) {
            return false;
        }
        if (!((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
            SoundHelper.playSound((class_18)world, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (String)"random.click", (float)0.3f, (float)0.6f);
            world.setBlockStateWithNotify(x, y, z, (BlockState)state.cycle((Property)Properties.POWERED));
            switch (((ButtonType)((Object)state.get(BUTTON_TYPE))).ordinal()) {
                case 0: {
                    world.method_244(x, y + 1, z, this.field_1915);
                    break;
                }
                case 1: {
                    world.method_244(x, y - 1, z, this.field_1915);
                    break;
                }
                case 2: {
                    Direction dir = ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)).getOpposite();
                    world.method_244(x + dir.getOffsetX(), y + dir.getOffsetY(), z + dir.getOffsetZ(), this.field_1915);
                }
            }
            world.method_216(x, y, z, this.field_1915, this.method_1565());
        }
        return true;
    }

    public boolean method_1569() {
        return true;
    }

    public boolean method_1568(class_14 blockView, int x, int y, int z, int direction) {
        if (blockView instanceof BlockStateView) {
            BlockStateView stateView = (BlockStateView)blockView;
            return (Boolean)stateView.getBlockState(x, y, z).get((Property)Properties.POWERED);
        }
        return false;
    }

    public boolean method_1570(class_18 world, int x, int y, int z, int direction) {
        BlockState state = world.getBlockState(x, y, z);
        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
            switch (((ButtonType)((Object)state.get(BUTTON_TYPE))).ordinal()) {
                case 0: {
                    return Direction.byId((int)direction) == Direction.DOWN;
                }
                case 1: {
                    return Direction.byId((int)direction) == Direction.UP;
                }
                case 2: {
                    return state.get((Property)Properties.HORIZONTAL_FACING) == Direction.byId((int)direction);
                }
            }
        }
        return false;
    }

    public void onStateReplaced(BlockState state, class_18 world, class_339 pos, BlockState newState) {
        if (state.isOf((class_17)this) && newState.isAir()) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            switch (((ButtonType)((Object)state.get(BUTTON_TYPE))).ordinal()) {
                case 0: {
                    world.method_244(x, y + 1, z, this.field_1915);
                    break;
                }
                case 1: {
                    world.method_244(x, y - 1, z, this.field_1915);
                    break;
                }
                case 2: {
                    Direction dir = ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)).getOpposite();
                    world.method_244(x + dir.getOffsetX(), y + dir.getOffsetY(), z + dir.getOffsetZ(), this.field_1915);
                }
            }
            world.method_216(x, y, z, this.field_1915, this.method_1565());
        }
    }

    public class_25 method_1624(class_18 world, int x, int y, int z) {
        return null;
    }

    public void method_1616(class_14 blockView, int x, int y, int z) {
        if (!(blockView instanceof BlockStateView)) {
            return;
        }
        BlockStateView view = (BlockStateView)blockView;
        BlockState state = view.getBlockState(x, y, z);
        block0 : switch (((ButtonType)((Object)state.get(BUTTON_TYPE))).ordinal()) {
            case 0: {
                switch ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)) {
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
                            this.method_1578(0.3125f, 0.9375f, 0.375f, 0.6875f, 1.0f, 0.625f);
                            break;
                        }
                        this.method_1578(0.3125f, 0.875f, 0.375f, 0.6875f, 1.0f, 0.625f);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
                            this.method_1578(0.375f, 0.9375f, 0.3125f, 0.625f, 1.0f, 0.6875f);
                            break;
                        }
                        this.method_1578(0.375f, 0.875f, 0.3125f, 0.625f, 1.0f, 0.6875f);
                    }
                }
                break;
            }
            case 1: {
                switch ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)) {
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
                            this.method_1578(0.3125f, 0.0f, 0.375f, 0.6875f, 0.0625f, 0.625f);
                            break;
                        }
                        this.method_1578(0.3125f, 0.0f, 0.375f, 0.6875f, 0.125f, 0.625f);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
                            this.method_1578(0.375f, 0.0f, 0.3125f, 0.625f, 0.0625f, 0.6875f);
                            break;
                        }
                        this.method_1578(0.375f, 0.0f, 0.3125f, 0.625f, 0.125f, 0.6875f);
                    }
                }
                break;
            }
            case 2: {
                switch ((Direction)state.get((Property)Properties.HORIZONTAL_FACING)) {
                    case EAST: {
                        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
                            this.method_1578(0.3125f, 0.375f, 1.0f, 0.6875f, 0.625f, 0.9375f);
                            break block0;
                        }
                        this.method_1578(0.3125f, 0.375f, 1.0f, 0.6875f, 0.625f, 0.875f);
                        break block0;
                    }
                    case WEST: {
                        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
                            this.method_1578(0.3125f, 0.375f, 0.0f, 0.6875f, 0.625f, 0.0625f);
                            break block0;
                        }
                        this.method_1578(0.3125f, 0.375f, 0.0f, 0.6875f, 0.625f, 0.125f);
                        break block0;
                    }
                    case NORTH: {
                        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
                            this.method_1578(0.9375f, 0.375f, 0.3125f, 1.0f, 0.625f, 0.6875f);
                            break block0;
                        }
                        this.method_1578(0.875f, 0.375f, 0.3125f, 1.0f, 0.625f, 0.6875f);
                        break block0;
                    }
                    case SOUTH: {
                        if (((Boolean)state.get((Property)Properties.POWERED)).booleanValue()) {
                            this.method_1578(0.0f, 0.375f, 0.3125f, 0.0625f, 0.625f, 0.6875f);
                            break block0;
                        }
                        this.method_1578(0.0f, 0.375f, 0.3125f, 0.125f, 0.625f, 0.6875f);
                    }
                }
            }
        }
    }

    public boolean method_1623() {
        return false;
    }

    public boolean method_1620() {
        return false;
    }

    public static enum ButtonType implements StringIdentifiable
    {
        CEILING("ceiling"),
        FLOOR("floor"),
        WALL("wall");

        public final String type;

        private ButtonType(String type) {
            this.type = type;
        }

        public String asString() {
            return this.type;
        }
    }
}

